#!/bin/sh
#
# File:        safety.sh
# Date:        08.03.2005
# Author:      Topi Pohjolainen
# Description: Generate the safety checks for scalabale amount of workers. 
#              We cannot iterate as we try avoid unnecessary variables.
#
if [[ -z $2 ]]; then
    echo "Usage: ./safety.sh <num_workers> <worker_pid_start>"
    exit
else
    WORKERS=$1
fi

echo "#ifndef GENERATED_SAFETY_SPN"
echo "#define GENERATED_SAFETY_SPN"
echo ""

################################################################################
# ControllerAndWorkerOnContent()
################################################################################
echo "#define ControllerAndWorkerOnContent(c_pid) \\"

for (( I=0; $WORKERS - $I; I = I + 1)); do
    TMP=`expr $2 + $I`
    echo -n " && !("
    echo    "(controller[c_pid]@CONTROLLER_2_WORKER_CONTENT_ACQUIRED_$I || \\"
    echo    " controller[c_pid]@CONTROLLER_WORKER_CONTENT_ACQUIRED_$I)  && \\"
    echo    "worker[$TMP]@WORKER_CONTENT_ACQUIRED                       && \\"
    echo -n "worker[$TMP]@WORKER_OUTPUT_RELEASED)"

    if (( $WORKERS > ($I + 1))); then 
        echo "\\"
    fi
done
echo ""
echo ""

################################################################################
# ControllerAndShutdownOnContent()
################################################################################
echo "#define ControllerAndShutdownOnContent(c_pid, shutdown_pid) \\"

for (( I=0; $WORKERS - $I; I = I + 1)); do
echo -n " && !("
echo "(controller[c_pid]@CONTROLLER_2_WORKER_CONTENT_ACQUIRED_$I ||\\"
echo " controller[c_pid]@CONTROLLER_WORKER_CONTENT_ACQUIRED_$I)  &&\\"
echo -n "shutdownScheduler[shutdown_pid]@SHUTDOWN_WORKER_CONTENT_ACQUIRED_$I)"

  if (( $WORKERS > ($I + 1))); then 
      echo "\\"
  fi
done
echo ""

echo "#endif // GENERATED_SAFETY_SPN"

# EOF
