#!/bin/sh
#
# File:        content_branches_generate.sh
# Date:        10.03.2005
# Author:      Topi Pohjolainen
# Description: Generate non-deterministic choices for worker content selection.
#

if [[ -z $1 ]]; then
    echo "Usage: ctrl_content_branches_generate <num_workers>"
    exit
else
    WORKERS=$1
fi

echo "#ifndef WORKER_CONTENT_SELECTION_SPN"
echo "#define WORKER_CONTENT_SELECTION_SPN"

echo ""

################################################################################
# WorkerContentSelection()
################################################################################

echo "#define WorkerContentSelection(selectedFlag, prefix) \\"
echo "    if                                               \\"

for (( I=0; $WORKERS - $I; I = I + 1)); do
  echo "    :: true -> LockAcquire(workersContentLocks[${I}], selectedFlag, \\"
  echo "prefix ## _WORKER_CONTENT_ACQUIRED_${I})                            \\"
  echo "               LockRelease(workersContentLocks[${I}], selectedFlag) \\"

  if (( $WORKERS <= ($I + 1))); then
     echo "    fi"
  fi
done

echo ""

################################################################################
# WorkerProcesses()
################################################################################

echo "#define WorkerProcesses() \\"
for (( I=0; $WORKERS - $I; I = I + 1)); do
    echo -n "run worker(${I})"

   if (( $WORKERS <= ($I + 1))); then
       echo ""
   else
       echo ";\\"
   fi
done

echo ""
echo ""
echo "#endif // WORKER_CONTENT_SELECTION_SPN"

# EOF
