#!/bin/bash
#
# File:         fairness.sh
# Date:         26.01.2005
# Author:       Topi Pohjolainen
# Description:  Generate instance of Maria model for given number of workers
#
if [[ -z $1 ]]; then
    echo "Usage: fairness.sh <num_workers>"
    exit
else
    WORKERS=$1
fi

echo "#ifndef FAIRNESS_CONSTRAINTS_PN"
echo "#define FAIRNESS_CONSTRAINTS_PN"
echo ""

################################################################################
# Weakly fair constraints
################################################################################

echo "weakly_fair"

for (( i=0; $WORKERS - $i; i=i+1 )); do
  echo "    trans worker_content_release : (worker == is Worker ${i}),"
done

for (( i=0; $WORKERS - $i; i=i+1 )); do
  echo "    trans worker_output_release : (worker == is Worker ${i}),"
done

echo "    trans startups_release,"
echo "    trans shutdowns_release,"
echo "    trans controller_startups_release,"
echo "    trans controller_shutdowns_release,"
echo "    trans terminator_outputs_release,"
echo "    trans terminator_contents_release,"
echo "    trans controller_workers_release,"
echo "    trans controller_workers_release_2,"
echo "    trans controller_content_release,"
echo "    trans startup_workers_release,"
echo "    trans shutdown_workers_release;"

echo ""

################################################################################
# Strongly fair constraints
################################################################################
echo "strongly_fair"

WORKERS=$1
for (( i=0; $WORKERS - $i; i=i+1 )); do
  echo "    trans worker_lock_output : (worker == is Worker ${i}),"
done

echo "    trans shutdown_workers_lock,"
echo "    trans startup_workers_lock,"
echo "    trans controller_shutdowns_lock,"
echo "    trans controller_workers_lock,"
echo "    trans controller_workers_content_lock,"
echo "    trans terminator_outputs_lock,"
echo "    trans terminator_contents_lock;"

echo "#endif // FAIRNESS_CONSTRAINTS_PN"

# EOF
