#!/bin/bash
#
# File:         analyse.sh
# Date:         26.01.2005
# Author:       Topi Pohjolainen
# Description:  Generate Maria and Spin models for increasing number of workers
#
if [[ -z $2 ]] || (( $1 < 1 )); then
    echo "Usage: fairness.sh <num_workers> <log_file>"
    exit
else
    MAX_NUM_WORKERS=$1
fi

MAX_NUM_WORKERS=0
for (( i=2; ($i <= $MAX_NUM_WORKERS); i=i+1 )); do
    cd maria; make -s WORKERS=${i} LOG=../${2}; make -s clean; cd ..
done

for (( i=2; ($i <= $MAX_NUM_WORKERS ); i=i+1 )); do
    cd maria; make -s WORKERS=${i} LOG=../${2} fair; make -s clean; cd ..
done

SPIN_DEPTH=4000000
MAX_NUM_WORKERS=0
for (( i=1; ($i <= $MAX_NUM_WORKERS ); i=i+1 )); do
    echo -n "spin fair ${i} "
    cd spin; make -s WORKERS=${i} fair;                                 \
             /usr/bin/time -f "%e" ./pan -a -m${SPIN_DEPTH} >> ../${2}; \
             make -s clean; cd ..
done

SPIN_DEPTH=4000000
for (( i=1; ($i <= $MAX_NUM_WORKERS ); i=i+1 )); do
    echo -n "spin progress ${i} "
    cd spin; make -s WORKERS=${i} progress;                             \
             /usr/bin/time -f "%e" ./pan -a -m${SPIN_DEPTH} >> ../${2}; \
             make -s clean; cd ..
done

MAX_NUM_WORKERS=$1
for (( i=1; ($i <= $MAX_NUM_WORKERS ); i=i+1 )); do
    echo -n "spin safety ${i} "
    cd spin; make -s WORKERS=${i};                                   \
             /usr/bin/time -f "%e" ./pan -m${SPIN_DEPTH} >> ../${2}; \
             make -s clean; cd ..
done

# EOF
