#!/usr/bin/perl

$benchmark_dir_dir="./benchmarks";
$exec_file="LIST_EXEC";
$l2s="./l2s4lmcs/bin/convert.bash";
$time="/usr/bin/time";

$run_L2SBMC_NOTIGHT_NONE_NUSMV_2_2_3_BDDs=1;
$run_L2SBMC_NOTIGHT_IC_NUSMV_2_2_3_BDDs=1;
$run_L2SBMC_NOTIGHT_IC_CAV2005_COMPL_UNROLL_OPT=1;
$run_L2SBMC_NOTIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT=1;
$run_L2SBMC_NOTIGHT_IC_NUSMV_2_2_3_ES_ZIGZAG=1;
$run_L2SBMC_TIGHT_NONE_NUSMV_2_2_3_BDDs=1;
$run_L2SBMC_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT=1;
$run_L2SBMC_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT=1;
$run_L2SBMC_TIGHT_NONE_NUSMV_2_2_3_ES_ZIGZAG=1;
$run_L2SBMC_TIGHT_IC_NUSMV_2_2_3_BDDs=1;
$run_L2SBMC_TIGHT_IC_CAV2005_COMPL_UNROLL_OPT=1;
$run_L2SBMC_TIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT=1;
$run_L2SBMC_TIGHT_IC_NUSMV_2_2_3_ES_ZIGZAG=1;
$run_L2SBMC_MAXUNROLL1_IC_NUSMV_2_2_3_BDDs=1;

$run_LTL_TIGHT_NONE_NUSMV_2_2_3_BDDs_f=1;
$run_LTL_TIGHT_NONE_NUSMV_2_2_3_BMC=1;
$run_LTL_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT=1;
$run_LTL_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT=1;
$run_LTL_NOTIGHT_NONE_NUSMV_2_2_3_BDDs_f=1;
$run_LTL_NOTIGHT_NONE_NUSMV_2_2_3_BMC=1;
$run_LTL_NOTIGHT_NONE_CAV2005_COMPL_UNROLL_OPT=1;
$run_LTL_NOTIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT=1;

$run_NUSMV_2_2_3_BDDs=1;
$run_NUSMV_2_2_3_BDDs_f=1;
$run_NUSMV_2_2_3_BMC=1;
$run_VMCAI2005=1;
$run_CAV2005_COMPL_UNROLL_NOOPT=1;
$run_CAV2005_NOCOMPL_UNROLL_NOOPT=1;
$run_CAV2005_COMPL_UNROLL_OPT=1;
$run_CAV2005_NOCOMPL_UNROLL_OPT=1;
$run_CAV2005_COMPL_NOUNROLL_OPT=1;
$run_CAV2005_NOCOMPL_NOUNROLL_OPT=1;

open(FILE, $exec_file);
while($exec_line = <FILE>) {
    chop($exec_line);
    ($exec_dir,$model,$property) = split(/ /, $exec_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "Dir '$exec_dir', model '$model', property '$property'\n";

    system("cp $benchmark_dir_dir/$exec_dir/$model.smv ./") && die "?";
    system("cp $benchmark_dir_dir/$exec_dir/$property.ltl ./") && die "?";
    system("cp $benchmark_dir_dir/$exec_dir/$model.$property.icvar ./") && die "?";


    #
    #
    # L2S
    #
    #

    #
    # -l2sbmc -notight, -optnone
    #
    system("$l2s -nusmv -l2sbmc -notight -optnone $model $property > $model.$property.out 2>&1");

    if($run_L2SBMC_NOTIGHT_NONE_NUSMV_2_2_3_BDDs) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_notight_none_NuSMV-2.2.3_BDDs/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -i $model.$property.l2sbmc.notight.none.ord $model.$property.l2sbmc.notight.none.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -notight -none
    system("rm -f $model.$property.l2sbmc.notight.none.ord");
    system("rm -f $model.$property.l2sbmc.notight.none.var");
    system("rm -f $model.$property.l2sbmc.notight.none.nusmv");



    #
    # -l2sbmc -notight, -optic
    #
    system("$l2s -nusmv -l2sbmc -notight -optic $model $property > $model.$property.out 2>&1");

    if($run_L2SBMC_NOTIGHT_IC_NUSMV_2_2_3_BDDs) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_BDDs/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -i $model.$property.l2sbmc.notight.ic.ord $model.$property.l2sbmc.notight.ic.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    $BMC_FILE="$model.$property.tmp";
    system("sed \"s/INVARSPEC/LTLSPEC G/\" < $model.$property.l2sbmc.notight.ic.nusmv > $BMC_FILE");

    if($run_L2SBMC_NOTIGHT_IC_CAV2005_COMPL_UNROLL_OPT) {
	# CAV2005(incr,compl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_notight_ic_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $BMC_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }
    if($run_L2SBMC_NOTIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT) {
	# CAV2005(incr,nocompl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_notight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $BMC_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    system("rm -f $BMC_FILE");

    if($run_L2SBMC_NOTIGHT_IC_NUSMV_2_2_3_ES_ZIGZAG) {
	# Standard NuSMV 2.2.3 with EenSorensson zigzag variant
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_ES_zigzag/$model.$property";
	$CMDFILE="./exec_cmds/exec_ES_zigzag.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.l2sbmc.notight.ic.nusmv  < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -notight -ic
    system("rm -f $model.$property.l2sbmc.notight.ic.ord");
    system("rm -f $model.$property.l2sbmc.notight.ic.var");
    system("rm -f $model.$property.l2sbmc.notight.ic.nusmv");



    #
    # -l2sbmc -tight, -optnone
    #
    system("$l2s -nusmv -l2sbmc -tight -optnone $model $property > $model.$property.out 2>&1");

    if($run_L2SBMC_TIGHT_NONE_NUSMV_2_2_3_BDDs) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_none_NuSMV-2.2.3_BDDs/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -i $model.$property.l2sbmc.tight.none.ord $model.$property.l2sbmc.tight.none.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    $BMC_FILE="$model.$property.tmp";
    system("sed \"s/INVARSPEC/LTLSPEC G/\" < $model.$property.l2sbmc.tight.none.nusmv > $BMC_FILE");

    if($run_L2SBMC_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT) {
	# CAV2005(incr,compl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $BMC_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_L2SBMC_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT) {
	# CAV2005(incr,nocompl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $BMC_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    system("rm -f $BMC_FILE");

    if($run_L2SBMC_TIGHT_NONE_NUSMV_2_2_3_ES_ZIGZAG) {
	# Standard NuSMV 2.2.3 with EenSorensson zigzag variant
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_none_NuSMV-2.2.3_ES_zigzag/$model.$property";
	$CMDFILE="./exec_cmds/exec_ES_zigzag.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.l2sbmc.tight.none.nusmv  < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -tight -none
    system("rm -f $model.$property.l2sbmc.tight.none.ord");
    system("rm -f $model.$property.l2sbmc.tight.none.var");
    system("rm -f $model.$property.l2sbmc.tight.none.nusmv");




    #
    # -l2sbmc -tight, -optic
    #
    system("$l2s -nusmv -l2sbmc -tight -optic $model $property > $model.$property.out 2>&1");

    if($run_L2SBMC_TIGHT_IC_NUSMV_2_2_3_BDDs) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_BDDs/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -i $model.$property.l2sbmc.tight.ic.ord $model.$property.l2sbmc.tight.ic.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    $BMC_FILE="$model.$property.tmp";
    system("sed \"s/INVARSPEC/LTLSPEC G/\" < $model.$property.l2sbmc.tight.ic.nusmv > $BMC_FILE");

    if($run_L2SBMC_TIGHT_IC_CAV2005_COMPL_UNROLL_OPT) {
	# CAV2005(incr,compl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $BMC_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }
    if($run_L2SBMC_TIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT) {
	# CAV2005(incr,nocompl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $BMC_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    system("rm -f $BMC_FILE");

    if($run_L2SBMC_TIGHT_IC_NUSMV_2_2_3_ES_ZIGZAG) {
	# Standard NuSMV 2.2.3 with EenSorensson zigzag variant
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_ES_zigzag/$model.$property";
	$CMDFILE="./exec_cmds/exec_ES_zigzag.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.l2sbmc.tight.ic.nusmv  < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -tight -ic
    system("rm -f $model.$property.l2sbmc.tight.ic.ord");
    system("rm -f $model.$property.l2sbmc.tight.ic.var");
    system("rm -f $model.$property.l2sbmc.tight.ic.nusmv");



    #
    # -l2sbmc -maxunroll=1, -optic
    #
    system("$l2s -nusmv -l2sbmc -maxunroll 1 -optic $model $property > $model.$property.out 2>&1");

    if($run_L2SBMC_MAXUNROLL1_IC_NUSMV_2_2_3_BDDs) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_l2sbmc_maxunroll1_ic_NuSMV-2.2.3_BDDs/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -i $model.$property.l2sbmc.maxunroll1.ic.ord $model.$property.l2sbmc.maxunroll1.ic.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -maxunroll=1 -ic
    system("rm -f $model.$property.l2sbmc.maxunroll1.ic.ord");
    system("rm -f $model.$property.l2sbmc.maxunroll1.ic.var");
    system("rm -f $model.$property.l2sbmc.maxunroll1.ic.nusmv");


    #
    #
    # Buchi
    #
    #

    #
    # -ltl -tight, -optnone
    #
    system("$l2s -nusmv -ltl -tight -optnone $model $property > $model.$property.out 2>&1");

    if($run_LTL_TIGHT_NONE_NUSMV_2_2_3_BDDs_f) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_tight_none_NuSMV-2.2.3_BDDs_f/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -f $model.$property.ltl.tight.none.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_LTL_TIGHT_NONE_NUSMV_2_2_3_BMC) {
	# Standard NuSMV 2.2.3 with BMC
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_tight_none_NuSMV-2.2.3_BMC/$model.$property";
	$CMDFILE="./exec_cmds/exec_check_ltlspec_bmc.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.ltl.tight.none.nusmv < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_LTL_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT) {
	# CAV2005(incr,compl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_tight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.ltl.tight.none.nusmv < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_LTL_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT) {
	# CAV2005(incr,nocompl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.ltl.tight.none.nusmv < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -tight -none
    system("rm -f $model.$property.ltl.tight.none.ord");
    system("rm -f $model.$property.ltl.tight.none.var");
    system("rm -f $model.$property.ltl.tight.none.nusmv");


    #
    # -ltl -notight, -optnone
    #
    system("$l2s -nusmv -ltl -notight -optnone $model $property > $model.$property.out 2>&1");

    if($run_LTL_NOTIGHT_NONE_NUSMV_2_2_3_BDDs_f) {
	# Standard NuSMV 2.2.3 with BDD based invariant checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_notight_none_NuSMV-2.2.3_BDDs_f/$model.$property";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -f $model.$property.ltl.notight.none.nusmv > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_LTL_NOTIGHT_NONE_NUSMV_2_2_3_BMC) {
	# Standard NuSMV 2.2.3 with BMC
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_notight_none_NuSMV-2.2.3_BMC/$model.$property";
	$CMDFILE="./exec_cmds/exec_check_ltlspec_bmc.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.ltl.notight.none.nusmv < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_LTL_NOTIGHT_NONE_CAV2005_COMPL_UNROLL_OPT) {
	# CAV2005(incr,compl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_notight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.ltl.notight.none.nusmv < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_LTL_NOTIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT) {
	# CAV2005(incr,nocompl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_ltl_notight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $model.$property.ltl.notight.none.nusmv < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    # Clean -notight -none
    system("rm -f $model.$property.ltl.notight.none.ord");
    system("rm -f $model.$property.ltl.notight.none.var");
    system("rm -f $model.$property.ltl.notight.none.nusmv");


    # Remove L2S output file
    system("rm -f $model.$property.out");


    #
    #
    # BMC and BDDs over standard LTLSPEC
    #
    #

    # Augment nusmv model file with ltlspec
    $PROBLEM_FILE="$model.$property.smv";
    system("cat $model.smv > $PROBLEM_FILE");
    system("echo \"LTLSPEC \" >> $PROBLEM_FILE");
    system("cat $property.ltl >> $PROBLEM_FILE");

    if($run_NUSMV_2_2_3_BDDs) {
	# Standard NuSMV 2.2.3 with BDD based LTL checking
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_NuSMV-2.2.3_BDDs/$model.$property";
	$CMDFILE="./exec_cmds/exec_check_ltlspec.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_NUSMV_2_2_3_BDDs_f) {
	# Standard NuSMV 2.2.3 with BDD based LTL checking and -f
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_NuSMV-2.2.3_BDDs_f/$model.$property";
	$CMDFILE="./exec_cmds/exec_check_ltlspec_f.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_NUSMV_2_2_3_BMC) {
	# Standard NuSMV 2.2.3 with BMC
	$NUSMV="./NuSMV-2.2.3/nusmv/NuSMV";
	$RESULT_FILE="Results/out_NuSMV-2.2.3_BMC/$model.$property";
	$CMDFILE="./exec_cmds/exec_check_ltlspec_bmc.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_VMCAI2005) {
	# VMCAI2005, version 2006-01-15
	$NUSMV="./NuSMV-2.2.3-VMCAI2005-20060115/nusmv-2.2.3-vmcai/NuSMV";
	$RESULT_FILE="Results/out_VMCAI2005_20060115/$model.$property";
	$CMDFILE="./exec_cmds/exec_VMCAI2005.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_CAV2005_COMPL_UNROLL_NOOPT) {
	# CAV2005(incr,compl,unroll,noopt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_CAV2005_20060119_incr_compl_unroll_noopt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_CAV2005_NOCOMPL_UNROLL_NOOPT) {
	# CAV2005(incr,nocompl,unroll,noopt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_CAV2005_20060119_incr_nocompl_unroll_noopt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_CAV2005_COMPL_UNROLL_OPT) {
	# CAV2005(incr,compl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_CAV2005_NOCOMPL_UNROLL_OPT) {
	# CAV2005(incr,nocompl,unroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_unroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_CAV2005_COMPL_NOUNROLL_OPT) {
	# CAV2005(incr,compl,nounroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_CAV2005_20060119_incr_compl_nounroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_compl_nounroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }

    if($run_CAV2005_NOCOMPL_NOUNROLL_OPT) {
	# CAV2005(incr,nocompl,nounroll,opt), version 2006-01-19
	$NUSMV="./NuSMV-2.2.3-CAV2005-20060119/nusmv/NuSMV";
	$RESULT_FILE="Results/out_CAV2005_20060119_incr_nocompl_nounroll_opt/$model.$property";
	$CMDFILE="./exec_cmds/exec_CAV2005_incr_nocompl_nounroll_opt.cmd";
	if(! -e "$RESULT_FILE.out") {
	    $cmd="$time -o $RESULT_FILE.time $NUSMV -int $PROBLEM_FILE < $CMDFILE > $RESULT_FILE.out 2>&1";
	    print "$cmd\n";
	    system("$cmd");
	}
    }


    # Clean BMC problem file
    system("rm -f $PROBLEM_FILE");

    system("rm -f $model.smv");
    system("rm -f $property.ltl");
    system("rm -f $model.$property.icvar");
}
