#!/usr/bin/perl

$LINES_IN_TABLE=60;
$BENCHMARK_DIRDIR="benchmarks";
$TIMEOUT=3600;
$DEFAULTCEX="-10";
$LATEX_FILE="show_scatter_plots";

open(LATEX, ">$LATEX_FILE.tex");
print LATEX "\\documentclass[a4paper]{article}\n";
print LATEX "\\usepackage{graphicx}\n";
print LATEX "\\usepackage[margin=1cm]{geometry}\n";
print LATEX "\\begin{document}\n";
print LATEX "\\noindent\n";

system("perl ./make_scatter_data.pl");

$list_sol_print="LIST_PRINT_JOURNAL_SCATTER";

@yo = (["NuSMV_2_2_3_BDDs","NuSMV(BDDLTL) no -f"],
       ["NuSMV_2_2_3_BDDs_f","NuSMV(BDDLTL)"],
       ["NuSMV_2_2_3_BMC","NuSMV(BMCLTL)"],
       ["l2sbmc_notight_none_NuSMV_2_2_3_BDDs","L2S(notight,none)+NuSMV(BDDINVAR)"],
       ["l2sbmc_tight_none_NuSMV_2_2_3_BDDs","L2S(tight,none)+NuSMV(BDDINVAR)"],
       ["l2sbmc_notight_ic_NuSMV_2_2_3_BDDs","L2S(notight,ic)+NuSMV(BDDINVAR)"],
       ["l2sbmc_tight_ic_NuSMV_2_2_3_BDDs","L2S(tight,ic)+NuSMV(BDDINVAR)"],
       ["l2sbmc_maxunroll1_ic_NuSMV_2_2_3_BDDs","L2S(maxunroll=1,ic)+NuSMV(BDDINVAR)"],

       ["l2sbmc_tight_none_CAV2005_compl_unroll_opt","L2S(tight,none)+CAV2005(compl,unroll,opt)"],
       ["l2sbmc_tight_none_CAV2005_nocompl_unroll_opt","L2S(tight,none)+CAV2005(nocompl,unroll,opt)"],
       ["l2sbmc_tight_ic_CAV2005_compl_unroll_opt","L2S(tight,ic)+CAV2005(compl,unroll,opt)"],
       ["l2sbmc_tight_ic_CAV2005_nocompl_unroll_opt","L2S(tight,ic)+CAV2005(nocompl,unroll,opt)"],
       ["l2sbmc_notight_ic_CAV2005_compl_unroll_opt","L2S(notight,ic)+CAV2005(compl,unroll,opt)"],
       ["l2sbmc_notight_ic_CAV2005_nocompl_unroll_opt","L2S(notight,ic)+CAV2005(nocompl,unroll,opt)"],

       ["ltl_notight_none_NuSMV_2_2_3_BDDs_f", "B(notight)+NuSMV(BDDLTL)"],
       ["ltl_notight_none_CAV2005_compl_unroll_opt", "B(notight)+CAV2005(compl,unroll,opt)"],
       ["ltl_notight_none_CAV2005_nocompl_unroll_opt", "B(notight)+CAV2005(nocompl,unroll,opt)"],
       ["ltl_tight_none_NuSMV_2_2_3_BDDs_f", "B(tight)+NuSMV(BDDLTL)"],
       ["ltl_tight_none_CAV2005_compl_unroll_opt", "B(tight)+CAV2005(compl,unroll,opt)"],
       ["ltl_tight_none_CAV2005_nocompl_unroll_opt", "B(tight)+CAV2005(nocompl,unroll,opt)"],

       ["l2sbmc_tight_none_NuSMV_2_2_3_ES_zigzag","L2S(tight,none)+NuSMV(ES)"],
       ["l2sbmc_tight_ic_NuSMV_2_2_3_ES_zigzag","L2S(tight,ic)+NuSMV(ES)"],
       ["l2sbmc_notight_ic_NuSMV_2_2_3_ES_zigzag","L2S(notight,ic)+NuSMV(ES)"],

       ["VMCAI2005","VMCAI2005"],
       ["CAV2005_compl_unroll_noopt","CAV2005(compl,unroll,noopt)"],
       ["CAV2005_nocompl_unroll_noopt","CAV2005(nocompl,unroll,noopt)"],
       ["CAV2005_compl_unroll_opt","CAV2005(compl,unroll,opt)"],
       ["CAV2005_compl_nounroll_opt","CAV2005(compl,nounroll,opt)"],
       ["CAV2005_nocompl_unroll_opt","CAV2005(nocompl,unroll,opt)"],
       ["CAV2005_nocompl_nounroll_opt","CAV2005(nocompl,nounroll,opt)"],
       );

$i = 0;
$length = @yo;
while($i < $length) {
    $j = 0;
    while($j < $length) {
	if($i eq $j) {
	    $j = $j + 1;
	    next;
	}
	$s1="scatter_data/" . @yo[$i]->[0];
	$t1=@yo[$i]->[1];
	$s2="scatter_data/" . @yo[$j]->[0];
	$t2=@yo[$j]->[1];
	$out="scatter_plots/" . @yo[$i]->[0] . "_vs_" . @yo[$j]->[0] . ".eps";
	print "making $out\n";
	do_plot($s1,$t1,$s2,$t2,$out);
	print LATEX "\\includegraphics[width=.2499\\linewidth]{scatter_plots/" . @yo[$i]->[0] . "_vs_" . @yo[$j]->[0] . "}\n";
	$j = $j + 1;
    }
    $i = $i+1;
}

print LATEX "\\end{document}\n";
close(LATEX);
system("latex $LATEX_FILE.tex");
system("dvipdf $LATEX_FILE.dvi");

exit;

sub do_plot {
    open(S1, "$s1");
    open(S2, "$s2");
    open(TMPt, ">scatter_data_tmpt");
    open(TMPf, ">scatter_data_tmpf");
    open(TMPu, ">scatter_data_tmpu");
    
    $index = 0;
    while(<S1>) {
	$s1_line = $_;
	$s2_line = <S2>;
	chop($s1_line);
	chop($s2_line);
	($s1_m,$s1_p,$s1_s,$s1_es) = split(/ /, $s1_line);
	($s2_m,$s2_p,$s2_s,$s2_es) = split(/ /, $s2_line);
	if(! ($s1_m =~ "#.*" && $s2_m =~ "#.*")) {
	    die "Internal error";
	}
	if(! ($s1_es eq $s2_es)) {
	    die "Internal error";
	}
	$s1_line = <S1>;
	$s2_line = <S2>;
	chop($s1_line);
	chop($s2_line);
	if($s1_es eq "t") {
	    print TMPt "$index $s1_line $s2_line\n";
	}
	elsif($s1_es eq "f") {
	    print TMPf "$index $s1_line $s2_line\n";
	}
	elsif($s1_es eq "?") {
	    print TMPu "$index $s1_line $s2_line\n";
	}
	else {
	    die "Internal error: '$s1_es'";
	}
	$index = $index+1;
    }
    close(S1);
    close(S2);
    close(TMPt);
    close(TMPf);
    close(TMPu);
    
    open(TMP, ">make_plot.gpl");
    print TMP "set out '$out.tmp'\n";
    print TMP "set terminal postscript eps color\n";
    print TMP "set log\n";
    print TMP "set autoscale\n";
    print TMP "set size square\n";
#    print TMP "set xrange [0.01:60000]\n";
#    print TMP "set yrange [0.01:60000]\n";
    print TMP "set xrange [0.01:30000]\n";
    print TMP "set yrange [0.01:30000]\n";
    print TMP "set xlabel \"$t1\"\n";
    print TMP "set ylabel \"$t2\"\n";
#    print TMP "set title \"time\"\n";
#    print TMP "set arrow from 0.01,7200 to 60000,7200 nohead\n";
#    print TMP "set arrow from 0.01,14400 to 60000,14400 nohead\n";
    print TMP "set arrow from 0.01,7200 to 30000,7200 nohead\n";
    print TMP "set arrow from 0.01,14400 to 30000,14400 nohead\n";
#    print TMP "set arrow from 0.01,28800 to 60000,28800 nohead\n";
    print TMP "set arrow from 7200, graph 0 to 7200, graph 1 nohead\n";
    print TMP "set arrow from 14400, graph 0 to 14400, graph 1 nohead\n";
#    print TMP "set arrow from 28800, graph 0 to 28800, graph 1 nohead\n";
    print TMP "plot \"scatter_data_tmpt\" using 3:5 title \"\" with points lt -1 pt 12, \"scatter_data_tmpf\" using 3:5 title \"\" with points lt 1 pt 4, x title \"\"\n";
#    print TMP "plot \"scatter_data_tmpt\" using 3:5 title \"\" with points lt -1 pt 12, \"scatter_data_tmpf\" using 3:5 title \"\" with points lt 1 pt 4, \"scatter_data_tmpu\" using 3:5 title \"\" with points lt -1 pt 2, x title \"\"\n";
    print TMP "quit\n";
    close(TMP);

    system("gnuplot < make_plot.gpl");

    system("sed -e \"s/%%BoundingBox: 50 50 410 302/%%BoundingBox: 50 50 320 302/\" $out.tmp > $out");
    system("rm -f $out.tmp");
}
