#!/usr/bin/perl

$LINES_IN_TABLE=60;
$BENCHMARK_DIRDIR="benchmarks";
$TIMEOUT=3600;
$DEFAULTCEX="-10";
$TIME_TIMEOUT=7200;
$TIME_MEMOUT=14400;
$TIME_NOTRUN=28800;

$list_print="LIST_PRINT_JOURNAL_SCATTER";
$check_solutions=1;

open(OUT_NuSMV_2_2_3_BDDs, ">scatter_data/NuSMV_2_2_3_BDDs") || die "?";
open(OUT_NuSMV_2_2_3_BDDs_f, ">scatter_data/NuSMV_2_2_3_BDDs_f") || die "?";
open(OUT_NuSMV_2_2_3_BMC, ">scatter_data/NuSMV_2_2_3_BMC") || die "?";
open(OUT_L2SBMC_NOTIGHT_NONE_NuSMV_2_2_3_BDDs, ">scatter_data/l2sbmc_notight_none_NuSMV_2_2_3_BDDs") || die "?";
open(OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_BDDs, ">scatter_data/l2sbmc_tight_none_NuSMV_2_2_3_BDDs") || die "?";
open(OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_BDDs, ">scatter_data/l2sbmc_notight_ic_NuSMV_2_2_3_BDDs") || die "?";
open(OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_BDDs, ">scatter_data/l2sbmc_tight_ic_NuSMV_2_2_3_BDDs") || die "?";
open(OUT_L2SBMC_MAXUNROLL1_IC_NuSMV_2_2_3_BDDs, ">scatter_data/l2sbmc_maxunroll1_ic_NuSMV_2_2_3_BDDs") || die "?";

open(OUT_L2SBMC_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT, ">scatter_data/l2sbmc_tight_none_CAV2005_compl_unroll_opt") || die "?";
open(OUT_L2SBMC_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT, ">scatter_data/l2sbmc_tight_none_CAV2005_nocompl_unroll_opt") || die "?";
open(OUT_L2SBMC_TIGHT_IC_CAV2005_COMPL_UNROLL_OPT, ">scatter_data/l2sbmc_tight_ic_CAV2005_compl_unroll_opt") || die "?";
open(OUT_L2SBMC_TIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT, ">scatter_data/l2sbmc_tight_ic_CAV2005_nocompl_unroll_opt") || die "?";
open(OUT_L2SBMC_NOTIGHT_IC_CAV2005_COMPL_UNROLL_OPT, ">scatter_data/l2sbmc_notight_ic_CAV2005_compl_unroll_opt") || die "?";
open(OUT_L2SBMC_NOTIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT, ">scatter_data/l2sbmc_notight_ic_CAV2005_nocompl_unroll_opt") || die "?";

open(OUT_LTL_NOTIGHT_NONE_NuSMV_2_2_3_BDDs_f, ">scatter_data/ltl_notight_none_NuSMV_2_2_3_BDDs_f") || die "?";
open(OUT_LTL_NOTIGHT_NONE_CAV2005_COMPL_UNROLL_OPT, ">scatter_data/ltl_notight_none_CAV2005_compl_unroll_opt") || die "?";
open(OUT_LTL_NOTIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT, ">scatter_data/ltl_notight_none_CAV2005_nocompl_unroll_opt") || die "?";
open(OUT_LTL_TIGHT_NONE_NuSMV_2_2_3_BDDs_f, ">scatter_data/ltl_tight_none_NuSMV_2_2_3_BDDs_f") || die "?";
open(OUT_LTL_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT, ">scatter_data/ltl_tight_none_CAV2005_compl_unroll_opt") || die "?";
open(OUT_LTL_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT, ">scatter_data/ltl_tight_none_CAV2005_nocompl_unroll_opt") || die "?";

open(OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_ES_ZIGZAG, ">scatter_data/l2sbmc_tight_none_NuSMV_2_2_3_ES_zigzag");
open(OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG, ">scatter_data/l2sbmc_tight_ic_NuSMV_2_2_3_ES_zigzag");
open(OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG, ">scatter_data/l2sbmc_notight_ic_NuSMV_2_2_3_ES_zigzag");

open(OUT_VMCAI2005, ">scatter_data/VMCAI2005") || die "?";
open(OUT_CAV2005_COMPL_UNROLL_NOOPT, ">scatter_data/CAV2005_compl_unroll_noopt") || die "?";
open(OUT_CAV2005_NOCOMPL_UNROLL_NOOPT, ">scatter_data/CAV2005_nocompl_unroll_noopt") || die "?";
open(OUT_CAV2005_COMPL_UNROLL_OPT, ">scatter_data/CAV2005_compl_unroll_opt") || die "?";
open(OUT_CAV2005_COMPL_NOUNROLL_OPT, ">scatter_data/CAV2005_compl_nounroll_opt") || die "?";
open(OUT_CAV2005_NOCOMPL_UNROLL_OPT, ">scatter_data/CAV2005_nocompl_unroll_opt") || die "?";
open(OUT_CAV2005_NOCOMPL_NOUNROLL_OPT, ">scatter_data/CAV2005_nocompl_nounroll_opt") || die "?";

open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property,$sol_sol) = split(/ /, $list_line);

    if($exec_dir =~ "#.*") {
	next;
    }
    print "# Making data on dir '$exec_dir', model '$model', property '$property'\n";
    make_row_standard($model,$property,$sol_sol);
}

close(OUT_NuSMV_2_2_3_BDDs);
close(OUT_NuSMV_2_2_3_BDDs_f);
close(OUT_NuSMV_2_2_3_BMC);
close(OUT_L2SBMC_NOTIGHT_NONE_NuSMV_2_2_3_BDDs);
close(OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_BDDs);
close(OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_BDDs);
close(OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_BDDs);
close(OUT_L2SBMC_MAXUNROLL1_IC_NuSMV_2_2_3_BDDs);

close(OUT_L2SBMC_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT);
close(OUT_L2SBMC_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT);
close(OUT_L2SBMC_TIGHT_IC_CAV2005_COMPL_UNROLL_OPT);
close(OUT_L2SBMC_TIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT);
close(OUT_L2SBMC_NOTIGHT_IC_CAV2005_COMPL_UNROLL_OPT);
close(OUT_L2SBMC_NOTIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT);

close(OUT_LTL_NOTIGHT_NONE_NuSMV_2_2_3_BDDs_f);
close(OUT_LTL_NOTIGHT_NONE_CAV2005_COMPL_UNROLL_OPT);
close(OUT_LTL_NOTIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT);
close(OUT_LTL_TIGHT_NONE_NuSMV_2_2_3_BDDs_f);
close(OUT_LTL_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT);
close(OUT_LTL_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT);

close(OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_ES_ZIGZAG);
close(OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG);
close(OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG);

close(OUT_VMCAI2005);
close(OUT_CAV2005_COMPL_UNROLL_NOOPT);
close(OUT_CAV2005_NOCOMPL_UNROLL_NOOPT);
close(OUT_CAV2005_COMPL_UNROLL_OPT);
close(OUT_CAV2005_COMPL_NOUNROLL_OPT);
close(OUT_CAV2005_NOCOMPL_UNROLL_OPT);
close(OUT_CAV2005_NOCOMPL_NOUNROLL_OPT);

exit;

sub check_sol
{
    local($model);
    local($property);
    local($algorithm);
    local($expected_sol);
    $model = $_[0];
    $property = $_[1];
    $algorithm = $_[2];
    $sol = $_[3];
    $expected_sol = $_[4];
    if($sol eq "") {
	;
    }
    elsif($sol eq "t") {
	if(! ($expected_sol eq $sol)) {
	    die "Algorithm '$algorithm' says '$sol', expected '$expected_sol'\n";
	}
    }
    elsif($sol eq "f") {
	if(! ($expected_sol eq $sol)) {
	    die "Algorithm '$algorithm' says '$sol', expected '$expected_sol'\n";
	}
    }
    else {
	die "Algorithm '$algorithm' says '$sol'";
    }
}


sub results_name {
    local($f);
    $f = $_[0];
    $f =~ s#benchmarks/##g;
    $f;
}

sub get_time {
    local($f);
    $f = $_[0];
    $time = "7200";
    open(FILE, $f);
    if(-e FILE) {
	$time="7200";
	while($line = <FILE>) {
	    if($line =~ "([0-9]*\.?[0-9]*)user.*") {
		$time = $1;
		last;
	    }
	}
    }
    $time;
}

sub get_time2 {
    local($f);
    local($s);
    $f = $_[0];
    $s = $_[1];
    $time = $TIME_NOTRUN;
    open(FILE, $f);
    if(-e FILE) {
	while($line = <FILE>) {
	    if($line =~ "([0-9]*\.?[0-9]*)user.*") {
		$time = $1;
		last;
	    }
	}
	close(FILE);
	# No solution, interpret time
	if($s eq "") {
	    if($time <= 3550) {
		$time = $TIME_MEMOUT;
	    } else {
		$time = $TIME_TIMEOUT;
	    }
	}
	$time;
    }
    else {
	# No time file, the benchmark was apparently not run
	$time;
    }
}

sub make_row_standard
{
    local($model);
    local($property);
    local($expected_sol);
    $model = $_[0];
    $property = $_[1];
    $expected_sol = $_[2];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;


    $prefix = "Results/out_NuSMV-2.2.3_BDDs/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile, $sol);
    print OUT_NuSMV_2_2_3_BDDs "#$model $property '$sol' $expected_sol\n";
    print OUT_NuSMV_2_2_3_BDDs "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"NuSMV-2.2.3_BDDs",$sol,$expected_sol);
    }


    $prefix = "Results/out_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_NuSMV_2_2_3_BDDs_f "#$model $property '$sol' $expected_sol\n";
    print OUT_NuSMV_2_2_3_BDDs_f "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"NuSMV-2.2.3_BDDs_f",$sol,$expected_sol);
    }



    $prefix = "Results/out_NuSMV-2.2.3_BMC/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile, $sol);
    print OUT_NuSMV_2_2_3_BMC "#$model $property '$sol' $expected_sol\n";
    print OUT_NuSMV_2_2_3_BMC "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"NuSMV-2.2.3_BMC",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_notight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_NOTIGHT_NONE_NuSMV_2_2_3_BDDs "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_NOTIGHT_NONE_NuSMV_2_2_3_BDDs "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(notight,none)+NuSMV-2.2.3_BDDs",$sol,$expected_sol);
    }



    $prefix = "Results/out_l2sbmc_tight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_BDDs "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_BDDs "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,none)+NuSMV-2.2.3_BDDs",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_BDDs "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_BDDs "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(notight,ic)+NuSMV-2.2.3_BDDs",$sol,$expected_sol);
    }




    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_BDDs "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_BDDs "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,ic)+NuSMV-2.2.3_BDDs",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_maxunroll1_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_MAXUNROLL1_IC_NuSMV_2_2_3_BDDs "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_MAXUNROLL1_IC_NuSMV_2_2_3_BDDs "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(maxunroll=1,ic)+NuSMV-2.2.3_BDDs",$sol,$expected_sol);
    }




    $prefix = "Results/out_l2sbmc_tight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,none)+CAV2005(comp,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,none)+CAV2005(nocomp,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_tight_none_NuSMV-2.2.3_ES_zigzag/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
                ($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_ES_ZIGZAG "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_NONE_NuSMV_2_2_3_ES_ZIGZAG "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,none)+NuSMV(ES zigzag)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_IC_CAV2005_COMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_IC_CAV2005_COMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,ic)+CAV2005(comp,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,ic)+CAV2005(nocomp,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_ES_zigzag/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
                ($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_TIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(tight,ic)+NuSMV(ES zigzag)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_notight_ic_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_NOTIGHT_IC_CAV2005_COMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_NOTIGHT_IC_CAV2005_COMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(notight,ic)+CAV2005(comp,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_notight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_NOTIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_NOTIGHT_IC_CAV2005_NOCOMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(notight,ic)+CAV2005(nocomp,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_ES_zigzag/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
                ($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG "#$model $property '$sol' $expected_sol\n";
    print OUT_L2SBMC_NOTIGHT_IC_NuSMV_2_2_3_ES_ZIGZAG "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"L2S(notight,ic)+NuSMV(ES zigzag)",$sol,$expected_sol);
    }


    $prefix = "Results/out_ltl_notight_none_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_LTL_NOTIGHT_NONE_NuSMV_2_2_3_BDDs_f "#$model $property '$sol' $expected_sol\n";
    print OUT_LTL_NOTIGHT_NONE_NuSMV_2_2_3_BDDs_f "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"B(notight)+NuSMV(BDDLTL)",$sol,$expected_sol);
    }


    $prefix = "Results/out_ltl_notight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_LTL_NOTIGHT_NONE_CAV2005_COMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_LTL_NOTIGHT_NONE_CAV2005_COMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"B(notight)+CAV2005(compl,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_ltl_notight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_LTL_NOTIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_LTL_NOTIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"B(notight)+CAV2005(nocompl,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_ltl_tight_none_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = $DEFAULTCEX;
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol eq "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print OUT_LTL_TIGHT_NONE_NuSMV_2_2_3_BDDs_f "#$model $property '$sol' $expected_sol\n";
    print OUT_LTL_TIGHT_NONE_NuSMV_2_2_3_BDDs_f "$cex_length $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"B(tight)+NuSMV(BDDLTL)",$sol,$expected_sol);
    }



    $prefix = "Results/out_ltl_tight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_LTL_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_LTL_TIGHT_NONE_CAV2005_COMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"B(tight)+CAV2005(compl,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_ltl_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_LTL_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_LTL_TIGHT_NONE_CAV2005_NOCOMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"B(tight)+CAV2005(nocompl,unroll,opt)",$sol,$expected_sol);
    }



    $prefix = "Results/out_VMCAI2005_20060115/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_VMCAI2005 "#$model $property '$sol' $expected_sol\n";
    print OUT_VMCAI2005 "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"VMCAI2005",$sol,$expected_sol);
    }


    $prefix = "Results/out_CAV2005_20060119_incr_compl_unroll_noopt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_CAV2005_COMPL_UNROLL_NOOPT "#$model $property '$sol' $expected_sol\n";
    print OUT_CAV2005_COMPL_UNROLL_NOOPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"CAV2005(compl,unroll,noopt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_unroll_noopt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_CAV2005_NOCOMPL_UNROLL_NOOPT "#$model $property '$sol' $expected_sol\n";
    print OUT_CAV2005_NOCOMPL_UNROLL_NOOPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"CAV2005(nocompl,unroll,noopt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_CAV2005_COMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_CAV2005_COMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"CAV2005(compl,unroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_CAV2005_20060119_incr_compl_nounroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_CAV2005_COMPL_NOUNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_CAV2005_COMPL_NOUNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"CAV2005(compl,nounroll,opt)",$sol,$expected_sol);
    }


    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_CAV2005_NOCOMPL_UNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_CAV2005_NOCOMPL_UNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"CAV2005(nocompl,unroll,opt)",$sol,$expected_sol);
    }



    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_nounroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = $DEFAULTCEX;
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print OUT_CAV2005_NOCOMPL_NOUNROLL_OPT "#$model $property '$sol' $expected_sol\n";
    print OUT_CAV2005_NOCOMPL_NOUNROLL_OPT "$k $time\n";
    if($check_solutions) {
	&check_sol($model,$property,"CAV2005(nocompl,nounroll,opt)",$sol,$expected_sol);
    }
}
