#!/usr/bin/perl

$LINES_IN_TABLE=100;
$BENCHMARK_DIRDIR="benchmarks";
$list_print="LIST_PRINT_JOURNAL";

$TIME_TIMEOUT="TO";
$TIME_MEMOUT="MO";
$TIME_NOTRUN="";


$lines=0;
make_tabular_begin();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property,$m_latex,$p_latex) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
        next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row($model,$property,$m_latex,$p_latex);
}
make_tabular_end();


exit;


sub results_name {
    local($f);
    $f = $_[0];
    $f =~ s#benchmarks/##g;
    $f;
}

sub get_time {
    local($f);
    $f = $_[0];
    $time = "";
    open(FILE, $f);
    if(-e FILE) {
	$time="?";
	while($line = <FILE>) {
	    if($line =~ "([0-9]*)\.?[0-9]*user.*") {
		$time = $1;
		last;
	    }
	}
    }
    $time;
}

sub get_time2 {
    local($f);
    local($s);
    $f = $_[0];
    $s = $_[1];
    $time = $TIME_NOTRUN;
    open(FILE, $f);
    if(-s FILE) {
	while($line = <FILE>) {
	    if($line =~ "([0-9]*)\.?[0-9]*user.*") {
		$time = $1;
		last;
	    }
	}
	close(FILE);
	if($s eq "") {
	    # No solution, interpret time
	    if($time <= 3550) {
		$time = $TIME_MEMOUT;
	    } else {
		$time = $TIME_TIMEOUT;
	    }
	}
	$time;
    }
    else {
	# No time file, the benchmark was apparently not run
	$time;
    }
}

sub make_tabular_begin
{
#    print "\\begin{table}[ht]\n";
#    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
#    print "\\tiny\n";
    print "\\begin{tabular}{|lr|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";

    print " & & \n";
    print "\\multicolumn{3}{|c}{\\textbf{NuSMV}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{L2S(notight,ic)}+}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{L2S(tight,ic)}+}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{L2S(tight,ic)}+}";
    print " & \n";
    print "\\multicolumn{3}{|c|}{\\textbf{B(tight)}+}";
    print "\\\\\n";

    print " & & \n";
    print "\\multicolumn{3}{|c}{(\\textbf{BDDLTL})}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{NuSMV}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{NuSMV}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{CAV2005}}";
    print " & \n";
    print "\\multicolumn{3}{|c|}{\\textbf{CAV2005}}";
    print "\\\\\n";

    print " & &\n";
    print "\\multicolumn{3}{|c}{}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{(BDDINVAR)}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{(BDDINVAR)}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{(nocompl,unroll,opt)}}";
    print " & \n";
    print "\\multicolumn{3}{|c|}{\\textbf{(nocompl,unroll,opt)}}";
    print "\\\\\n";

    print "model & prop. &\n";
    print "a & \$|\\textup{cex}|\$ & t ";
    print " & \n";
    print "a & \$|\\textup{cex}|\$ & t ";
    print " & \n";
    print "a & \$|\\textup{cex}|\$ & t ";
    print " & \n";
    print "a & k & t ";
    print " & \n";
    print "a & k & t ";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
#    print "\n\n";
}


sub make_row
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];
    local($m_latex);
    local($p_latex);
    $m_latex = $_[2];
    $p_latex = $_[3];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$m_latex & $p_latex & \n";

    $prefix = "Results/out_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%NuSMV 2.2.3 BDD-based check_ltlspec -f\n";
    print "$sol & $cex_length & $time ";
    print "& \n";



    $prefix = "Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc notight ic NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight ic NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_ltl_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";

    print "\\\\\n";

    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end();
	make_tabular_begin();
    }
    if(($lines) % 5 == 0) {
	print "\\hline\n";
    }

}
