#!/usr/bin/perl

$LINES_IN_TABLE=100;
$BENCHMARK_DIRDIR="benchmarks";
$list_print="LIST_PRINT_JOURNAL";

$TIME_TIMEOUT="TO";
$TIME_MEMOUT="MO";
$TIME_NOTRUN="";

$lines=0;
make_tabular_begin();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property,$m_latex,$p_latex) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
        next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row($model,$property,$m_latex,$p_latex);
}
make_tabular_end();


exit;


sub results_name {
    local($f);
    $f = $_[0];
    $f =~ s#benchmarks/##g;
    $f;
}

sub get_time {
    local($f);
    $f = $_[0];
    $time = "";
    open(FILE, $f);
    if(-e FILE) {
	$time="?";
	while($line = <FILE>) {
	    if($line =~ "([0-9]*)\.?[0-9]*user.*") {
		$time = $1;
		last;
	    }
	}
    }
    $time;
}

sub get_time2 {
    local($f);
    local($s);
    $f = $_[0];
    $s = $_[1];
    $time = $TIME_NOTRUN;
    open(FILE, $f);
    if(-s FILE) {
	while($line = <FILE>) {
	    if($line =~ "([0-9]*)\.?[0-9]*user.*") {
		$time = $1;
		last;
	    }
	}
	close(FILE);
	if($s eq "") {
	    # No solution, interpret time
	    if($time <= 3550) {
		$time = $TIME_MEMOUT;
	    } else {
		$time = $TIME_TIMEOUT;
	    }
	}
	$time;
    }
    else {
	# No time file, the benchmark was apparently not run
	$time;
    }
}

sub make_tabular_begin
{
#    print "\\begin{table}[ht]\n";
#    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
#    print "\\tiny\n";
    print "\\begin{tabular}{|lr|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";

    print " & & \n";
    print "\\multicolumn{3}{|c}{\\textbf{NuSMV}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{VMCAI2005}}";
    print " & \n";
    print "\\multicolumn{3}{|c}{\\textbf{CAV2005}}";
    print " & \n";
    print "\\multicolumn{3}{|c|}{\\textbf{CAV2005}}";
    print "\\\\\n";

    print " & & \n";
    print "\\multicolumn{3}{|c}{(\\textbf{BMCLTL})}";
    print " & \n";
    print "\\multicolumn{3}{|c}{}";
    print " & \n";
    print "\\multicolumn{3}{|c}{(\\textbf{nocompl,unroll,opt})}";
    print " & \n";
    print "\\multicolumn{3}{|c|}{(\\textbf{compl,unroll,opt})}";
    print "\\\\\n";

    print "model & prop. &\n";
    print "a & k & t"; print " & \n";
    print "a & k & t"; print " & \n";
    print "a & k & t"; print " & \n";
    print "a & k & t"; #print " & \n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
#    print "\n\n";
}


sub make_row
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];
    local($m_latex);
    local($p_latex);
    $m_latex = $_[2];
    $p_latex = $_[3];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$m_latex & $p_latex & \n";
    #print "($model_tex,$property_tex) & \n";


    $prefix = "Results/out_NuSMV-2.2.3_BMC/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "";
    if(-e FILE) {
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    #print "%NuSMV 2.2.3 bmc\n";
    #print "$sol & $k & $time ";
    #print "\n";
    $nusmv_bmcltl_sol = $sol;
    $nusmv_bmcltl_k = $k;
    $nusmv_bmcltl_time = $time;



    $prefix = "Results/out_VMCAI2005_20060115/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
        $time = "NA";
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    $vmcai2005_sol = $sol;
    $vmcai2005_k = $k;
    $vmcai2005_time = $time;

    
    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
        $time = "NA";
        while($line = <FILE>) {
            if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
                $k = $1;
                $st = $2;
                $time = $3;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    $cav2005_nocompl_unroll_opt_sol = $sol;
    $cav2005_nocompl_unroll_opt_k = $k;
    $cav2005_nocompl_unroll_opt_time = $time;
    

    $prefix = "Results/out_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
        $time = "NA";
        while($line = <FILE>) {
            if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
                $k = $1;
                $st = $2;
                $time = $3;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    $cav2005_compl_unroll_opt_sol = $sol;
    $cav2005_compl_unroll_opt_k = $k;
    $cav2005_compl_unroll_opt_time = $time;
    

    print "%NuSMV 2.2.3 bmc\n";
    print "$nusmv_bmcltl_sol & $nusmv_bmcltl_k & $nusmv_bmcltl_time ";
    print "& \n";

    print "%VMCAI2005, 2.2.3\n";
    print "$vmcai2005_sol & $vmcai2005_k & $vmcai2005_time ";
    print "& \n";

    print "%CAV2005(nocompl,unroll,opt), 2.2.3\n";
    print "$cav2005_nocompl_unroll_opt_sol & $cav2005_nocompl_unroll_opt_k & $cav2005_nocompl_unroll_opt_time ";
    print "& \n";

    print "%CAV2005(compl,unroll,opt), 2.2.3\n";
    print "$cav2005_compl_unroll_opt_sol & $cav2005_compl_unroll_opt_k & $cav2005_compl_unroll_opt_time ";
#    print "& \n";

    print "\\\\\n";

    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end();
	make_tabular_begin();
    }
    if(($lines) % 5 == 0) {
	print "\\hline\n";
    }

}
