#!/usr/bin/perl

$LINES_IN_TABLE=60;
$BENCHMARK_DIRDIR="benchmarks";
$TIME_TIMEOUT="TO";
$TIME_MEMOUT="MO";
$TIME_NOTRUN="";

$list_print="LIST_PRINT";

#
# Standard NuSMV 2.2.3 results
#
$lines=0;
make_tabular_begin_standard();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_standard($model,$property);
}
make_tabular_end_standard();

print "\\newpage\n";

$lines=0;
make_tabular_begin_L2S();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_L2S($model,$property);
}
make_tabular_end_L2S();

#print "\\newpage\n";
#
#$lines=0;
#make_tabular_begin_L2Sb();
#open(LIST_PRINT, $list_print);
#while($list_line = <LIST_PRINT>) {
#    chop($list_line);
#    ($exec_dir,$model,$property) = split(/ /, $list_line);
#    if($exec_dir =~ "#.*") {
#	next;
#    }
#    print "% Dir '$exec_dir', model '$model', property '$property'\n";
#    make_row_L2Sb($model,$property);
#}
#make_tabular_end_L2Sb();

print "\\newpage\n";

$lines=0;
make_tabular_begin_L2Sc();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_L2Sc($model,$property);
}
make_tabular_end_L2Sc();

print "\\newpage\n";

$lines=0;
make_tabular_begin_L2Sd();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_L2Sd($model,$property);
}
make_tabular_end_L2Sd();

print "\\newpage\n";

$lines=0;
make_tabular_begin_L2Se();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_L2Se($model,$property);
}
make_tabular_end_L2Se();

print "\\newpage\n";

$lines=0;
make_tabular_begin_L2Sf();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_L2Sf($model,$property);
}
make_tabular_end_L2Sf();

print "\\newpage\n";

$lines=0;
make_tabular_begin_BMC2();
open(LIST_PRINT, $list_print);
while($list_line = <LIST_PRINT>) {
    chop($list_line);
    ($exec_dir,$model,$property) = split(/ /, $list_line);
    if($exec_dir =~ "#.*") {
	next;
    }
    print "% Dir '$exec_dir', model '$model', property '$property'\n";
    make_row_BMC2($model,$property);
}
make_tabular_end_BMC2();

exit;


sub results_name {
    local($f);
    $f = $_[0];
    $f =~ s#benchmarks/##g;
    $f;
}

sub get_time {
    local($f);
    $f = $_[0];
    $time = "";
    open(FILE, $f);
    if(-e FILE) {
	$time="?";
	while($line = <FILE>) {
	    if($line =~ "([0-9]*)\.?[0-9]*user.*") {
		$time = $1;
		last;
	    }
	}
    }
    $time;
}

sub get_time2 {
    local($f);
    local($s);
    $f = $_[0];
    $s = $_[1];
    $time = $TIME_NOTRUN;
    open(FILE, $f);
    if(-s FILE) {
	while($line = <FILE>) {
	    if($line =~ "([0-9]*)\.?[0-9]*user.*") {
		$time = $1;
		last;
	    }
	}
	close(FILE);
	if($s eq "") {
	    # No solution, interpret time
	    if($time <= 3550) {
		$time = $TIME_MEMOUT;
	    } else {
		$time = $TIME_TIMEOUT;
	    }
	}
	$time;
    }
    else {
	# No time file, the benchmark was apparently not run
	$time;
    }
}

sub make_tabular_begin_standard
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3} &\n";
    print "\\multicolumn{3}{|c|}{NuSMV 2.2.3}\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{check\\_ltlspec} &\n";
    print "\\multicolumn{3}{|c}{check\\_ltlspec -f} &\n";
    print "\\multicolumn{3}{|c|}{check\\_ltlspec\\_bmc}\n";
    print "\\\\\n";
    print "file &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & k & t\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_standard
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_standard
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";



    $prefix = "Results/out_NuSMV-2.2.3_BDDs/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%NuSMV 2.2.3 BDD-based check_ltlspec\n";
    print "$sol & $cex_length & $time ";
    print "& \n";



    $prefix = "Results/out_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%NuSMV 2.2.3 BDD-based check_ltlspec\n";
    print "$sol & $cex_length & $time ";
    print "& \n";



    $prefix = "Results/out_NuSMV-2.2.3_BMC/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "";
    if(-e FILE) {
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%NuSMV 2.2.3 bmc\n";
    print "$sol & $k & $time ";
    print "\n";

    print "\\\\\n";

    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_standard();
	make_tabular_begin_standard();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }

}





sub make_tabular_begin_L2S
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -notight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -notight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -tight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -maxunroll 1 -ic} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_L2S
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_L2S
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_l2sbmc_notight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc notight none NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";



    $prefix = "Results/out_l2sbmc_tight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight none NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc notight ic NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";




    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight ic NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_maxunroll1_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc maxunroll1 ic NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";

    print "\\\\\n";

    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_L2S();
	make_tabular_begin_L2S();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }

}



sub make_tabular_begin_L2Sb
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -notight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -notight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -tight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2smbc -tight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -notight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -notight -none} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 ES zigzag} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs -f} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BMC} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & k & t &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & k & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_L2Sb
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_L2Sb
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_l2sbmc_notight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc notight none NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";



    $prefix = "Results/out_l2sbmc_tight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight none NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc notight ic NuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";




    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight icNuSMV 2.2.3 BDDs\n";
    print "$sol & $cex_length & $time ";
    print "& \n";



    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_ES_zigzag/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight ic NuSMV 2.2.3 ES zigzag\n";
    print "$sol & $k & $time ";
    print "& \n";



    $prefix = "Results/out_ltl_notight_none_NuSMV-2.2.3_BDDs/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S ltl notight none NuSMV 2.2.3 BDDs -f\n";
    print "$sol & $cex_length & $time ";
    print "& \n";




    $prefix = "Results/out_ltl_notight_none_NuSMV-2.2.3_BMC/" . $model . "." . $property;
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "";
    if(-e FILE) {
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S ltl notight none NuSMV 2.2.3 BMC\n";
    print "$sol & $k & $time ";
    print "& \n";

    print "\\\\\n";

    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_L2Sb();
	make_tabular_begin_L2Sb();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }

}




sub make_tabular_begin_L2Sc
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -tight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -tight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -tight -ic} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{CAV2005 compl, unroll, opt} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 nocompl, unroll, opt} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 ES zigzag} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 compl, unroll, opt} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 nocompl, unroll, opt} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 ES zigzag} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_L2Sc
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_L2Sc
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_l2sbmc_tight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_l2sbmc_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_l2sbmc_tight_none_NuSMV-2.2.3_ES_zigzag/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
                ($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight none NuSMV 2.2.3 ES zigzag\n";
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_l2sbmc_tight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 completeness nounroll opt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_l2sbmc_tight_ic_NuSMV-2.2.3_ES_zigzag/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
                ($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc tight ic NuSMV 2.2.3 ES zigzag\n";
    print "$sol & $k & $time ";
    print "& \n";

    print "\\\\\n";


    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_L2Sc();
	make_tabular_begin_L2Sc();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }
}




sub make_tabular_begin_L2Sd
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -notight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -notight -ic} &\n";
    print "\\multicolumn{3}{|c}{SB -l2sbmc -notight -ic} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{CAV2005(compl,unroll,opt)} &\n";
    print "\\multicolumn{3}{|c}{CAV2005(nocompl,unroll,opt)} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 ES zigzag} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_L2Sd
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_L2Sd
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_l2sbmc_notight_ic_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_l2sbmc_notight_ic_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_l2sbmc_notight_ic_NuSMV-2.2.3_ES_zigzag/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- invariant .* is (.).*") {
                ($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-- no proof or counterexample found with bound (.*).*") {
                $k = $1+1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S l2sbmc notight ic NuSMV 2.2.3 ES zigzag\n";
    print "$sol & $k & $time ";
    print "& \n";

    print "\\\\\n";


    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_L2Sd();
	make_tabular_begin_L2Sd();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }
}




sub make_tabular_begin_L2Se
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}%\n";
#    print "\\centering\n";
    print "\\tiny%\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -notight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -notight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -notight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -notight -none} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs -f} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BMC} &\n";
    print "\\multicolumn{3}{|c}{CAV2005(compl,unroll,opt)} &\n";
    print "\\multicolumn{3}{|c}{CAV2005(nocompl,unroll,opt)} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_L2Se
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_L2Se
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_ltl_notight_none_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S ltl notight none NuSMV 2.2.3 BDDs -f\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_ltl_notight_none_NuSMV-2.2.3_BMC/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "";
    if(-e FILE) {
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S ltl notight none NuSMV 2.2.3 bmc\n";
    print "$sol & $k & $time ";
    print " & \n";


    $prefix = "Results/out_ltl_notight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_ltl_notight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";



    print "\\\\\n";


    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_L2Se();
	make_tabular_begin_L2Se();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }
}




sub make_tabular_begin_L2Sf
{
#    print "\\begin{table}[!H]\n";
    print "\\hspace{-5cm}\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -tight -none} &\n";
    print "\\multicolumn{3}{|c}{SB -ltl -tight -none} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BDDs -f} &\n";
    print "\\multicolumn{3}{|c}{NuSMV 2.2.3 BMC} &\n";
    print "\\multicolumn{3}{|c}{CAV2005(compl,unroll,opt)} &\n";
    print "\\multicolumn{3}{|c}{CAV2005(nocompl,unroll,opt)} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & \$|\\textup{cex}|\$ & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_L2Sf
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_L2Sf
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_ltl_tight_none_NuSMV-2.2.3_BDDs_f/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $cex_length = "";
    if(-e FILE) {
        $sol = "";
        while($line = <FILE>) {
            if($line =~ "-- specification .* is (.).*") {
		($sol == "") || die "Double answer in $outfile";
                $sol = $1;
            }
            if($line =~ "-> State: 1.(.*) <-") {
                $cex_length = $1-1;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S ltl tight none NuSMV 2.2.3 BDDs -f\n";
    print "$sol & $cex_length & $time ";
    print "& \n";


    $prefix = "Results/out_ltl_tight_none_NuSMV-2.2.3_BMC/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "";
    if(-e FILE) {
        while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
            if($line =~ "-- specification .* is (.).*") {
                $sol = $1;
                last;
            }
        }
    }
    $time = &get_time2($timefile,$sol);
    print "%L2S ltl tight none NuSMV 2.2.3 bmc\n";
    print "$sol & $k & $time ";
    print " & \n";


    $prefix = "Results/out_ltl_tight_none_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_ltl_tight_none_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "$sol & $k & $time ";
    print "& \n";

    print "\\\\\n";


    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_L2Sf();
	make_tabular_begin_L2Sf();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }
}




sub make_tabular_begin_BMC2
{
#    print "\\begin{table}[!H]\n";
#    print "\\centering\n";
    print "\\tiny\n";
    print "\\hspace{-5cm}%\n";
    print "\\begin{tabular}{|l|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|r|}\n";
    print "\\hline\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{VMCAI2005} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 incr} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 incr} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 incr} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 incr} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 incr} &\n";
    print "\\multicolumn{3}{|c}{CAV2005 incr} &\n";
    print "\\\\\n";
    print " &\n";
    print "\\multicolumn{3}{|c}{} &\n";
    print "\\multicolumn{3}{|c}{compl, unroll} &\n";
    print "\\multicolumn{3}{|c}{nocompl, unroll} &\n";
    print "\\multicolumn{3}{|c}{compl, unroll, opt} &\n";
    print "\\multicolumn{3}{|c}{compl, nounroll, opt} &\n";
    print "\\multicolumn{3}{|c}{nocompl, unroll, opt} &\n";
    print "\\multicolumn{3}{|c}{nocompl, nounroll, opt} &\n";
    print "\\\\\n";
    print "file &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "a & k & t &\n";
    print "\\\\\n";
    print "\\hline\n";
}

sub make_tabular_end_BMC2
{
    print "\\hline\n";
    print "\\end{tabular}\n";
#    print "\\end{table}\n";
    print "\n\n";
}


sub make_row_BMC2
{
    local($model);
    local($property);
    $model = $_[0];
    $property = $_[1];

    $model_tex = $model;
    $model_tex =~ s/\_/\\_/g;
    $model_tex =~ s/\^/\\_/g;

    $property_tex = $property;
    $property_tex =~ s/\_/\\_/g;
    $property_tex =~ s/\^/\\_/g;

    print "$model_tex.$property_tex & \n";


    $prefix = "Results/out_VMCAI2005_20060115/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
            if($line =~ ".* with bound ([0-9]*).*") {
                $k = $1;
            }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%VMCAI2005, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_CAV2005_20060119_incr_compl_unroll_noopt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 completeness unroll noopt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_unroll_noopt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 nocompleteness unroll noopt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";

    $prefix = "Results/out_CAV2005_20060119_incr_compl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 completeness unroll opt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_CAV2005_20060119_incr_compl_nounroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 completeness nounroll opt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_unroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 nocompleteness unroll opt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";


    $prefix = "Results/out_CAV2005_20060119_incr_nocompl_nounroll_opt/$model.$property";
    $outfile = $prefix . ".out";
    $timefile = $prefix . ".time";
    open(FILE, $outfile);
    $sol = "";
    $k = "";
    $st = "";
    $time = "NR";
    if(-e FILE) {
	$time = "NA";
	while($line = <FILE>) {
	    if($line =~ "TJ: .*, k=(.*), solver time=(.*), cumulative time=([0-9]*)\.[0-9]?.*\.\n") {
		$k = $1;
		$st = $2;
		$time = $3;
	    }
	    if($line =~ "-- specification .* is (.).*") {
		$sol = $1;
		last;
	    }
	}
    }
    $time = &get_time2($timefile,$sol);
    print "%CAV2005 nocompleteness nounroll opt, 2.2.3\n";
    print "$sol & $k & $time ";
    print "& \n";


    print "\\\\\n";


    $lines = ($lines+1) % $LINES_IN_TABLE;
    if($lines == 0) {
	make_tabular_end_BMC2();
	make_tabular_begin_BMC2();
    }
    if($lines != 0 && ($lines) % 5 == 0) {
	print "\\hline\n";
    }
}
