#!/usr/bin/perl

$LINES_IN_TABLE=60;
$BENCHMARK_DIRDIR="benchmarks";
$TIMEOUT=3600;
$DEFAULTCEX="-10";

sub by_first {
    #print $a->[0]." $a[1] $b[0] $b[1] $a\n";
    if(($a->[0] <=> $b->[0]) == 0) {
	$a->[1] <=> $b->[1];
    } else {
	$a->[0] <=> $b->[0];
    }
}
sub max {
    if(scalar($_[0]) > scalar($_[1])) {
	$_[0];
    }
    $_[1];
}



@yo = (["NuSMV_2_2_3_BDDs","NuSMV(BDDLTL) no -f"],
       ["NuSMV_2_2_3_BDDs_f","NuSMV(BDDLTL)"],
       ["NuSMV_2_2_3_BMC","NuSMV(BMCLTL)"],
       ["l2sbmc_notight_none_NuSMV_2_2_3_BDDs","L2S(notight,none)+NuSMV(BDDINVAR)"],
       ["l2sbmc_tight_none_NuSMV_2_2_3_BDDs","L2S(tight,none)+NuSMV(BDDINVAR)"],
       ["l2sbmc_notight_ic_NuSMV_2_2_3_BDDs","L2S(notight,ic)+NuSMV(BDDINVAR)"],
       ["l2sbmc_tight_ic_NuSMV_2_2_3_BDDs","L2S(tight,ic)+NuSMV(BDDINVAR)"],
       ["l2sbmc_maxunroll1_ic_NuSMV_2_2_3_BDDs","L2S(maxunroll=1,ic)+NuSMV(BDDINVAR)"],

       ["l2sbmc_tight_none_CAV2005_compl_unroll_opt","L2S(tight,none)+CAV2005(compl,unroll,opt)"],
       ["l2sbmc_tight_none_CAV2005_nocompl_unroll_opt","L2S(tight,none)+CAV2005(nocompl,unroll,opt)"],
       ["l2sbmc_tight_ic_CAV2005_compl_unroll_opt","L2S(tight,ic)+CAV2005(compl,unroll,opt)"],
       ["l2sbmc_tight_ic_CAV2005_nocompl_unroll_opt","L2S(tight,ic)+CAV2005(nocompl,unroll,opt)"],
       ["l2sbmc_notight_ic_CAV2005_compl_unroll_opt","L2S(notight,ic)+CAV2005(compl,unroll,opt)"],
       ["l2sbmc_notight_ic_CAV2005_nocompl_unroll_opt","L2S(notight,ic)+CAV2005(nocompl,unroll,opt)"],

       ["ltl_notight_none_NuSMV_2_2_3_BDDs_f", "B(notight)+NuSMV(BDDLTL)"],
       ["ltl_notight_none_CAV2005_compl_unroll_opt", "B(notight)+CAV2005(compl,unroll,opt)"],
       ["ltl_notight_none_CAV2005_nocompl_unroll_opt", "B(notight)+CAV2005(nocompl,unroll,opt)"],
       ["ltl_tight_none_NuSMV_2_2_3_BDDs_f", "B(tight)+NuSMV(BDDLTL)"],
       ["ltl_tight_none_CAV2005_compl_unroll_opt", "B(tight)+CAV2005(compl,unroll,opt)"],
       ["ltl_tight_none_CAV2005_nocompl_unroll_opt", "B(tight)+CAV2005(nocompl,unroll,opt)"],

       ["l2sbmc_tight_none_NuSMV_2_2_3_ES_zigzag","L2S(tight,none)+NuSMV(ES)"],
       ["l2sbmc_tight_ic_NuSMV_2_2_3_ES_zigzag","L2S(tight,ic)+NuSMV(ES)"],
       ["l2sbmc_notight_ic_NuSMV_2_2_3_ES_zigzag","L2S(notight,ic)+NuSMV(ES)"],

       ["VMCAI2005","VMCAI2005"],
       ["CAV2005_compl_unroll_noopt","CAV2005(compl,unroll,noopt)"],
       ["CAV2005_nocompl_unroll_noopt","CAV2005(nocompl,unroll,noopt)"],
       ["CAV2005_compl_unroll_opt","CAV2005(compl,unroll,opt)"],
       ["CAV2005_compl_nounroll_opt","CAV2005(compl,nounroll,opt)"],
       ["CAV2005_nocompl_unroll_opt","CAV2005(nocompl,unroll,opt)"],
       ["CAV2005_nocompl_nounroll_opt","CAV2005(nocompl,nounroll,opt)"],
       );

$i = 0;
$length = @yo;
while($i < $length) {
    $j = 0;
    while($j < $length) {
	if($i eq $j) {
	    $j = $j + 1;
	    next;
	}
	$s1="scatter_data/" . @yo[$i]->[0];
	$t1=@yo[$i]->[1];
	$s2="scatter_data/" . @yo[$j]->[0];
	$t2=@yo[$j]->[1];
	$out="bound_plots/" . @yo[$i]->[0] . "_vs_" . @yo[$j]->[0] . ".eps";
	$outbar="bound_plots/b_" . @yo[$i]->[0] . "_vs_" . @yo[$j]->[0] . ".eps";
	print "making $out\n";
	do_plot($s1,$t1,$s2,$t2,$out);
	$j = $j + 1;
    }
    $i = $i+1;
}

exit;

sub do_plot {
    local(@a);
    local(@b);
    local($index);
    local($j);
    local($l);
    local($m);

    open(S1, "$s1");
    open(S2, "$s2");
    open(TMP, ">bound_data.tmp");

    while(<S1>) {
	$s1_line = $_;
	$s2_line = <S2>;
	chop($s1_line);
	chop($s2_line);
	($s1_m,$s1_p,$s1_s,$s1_es) = split(/ /, $s1_line);
	($s2_m,$s2_p,$s2_s,$s2_es) = split(/ /, $s2_line);
	if(! ($s1_m =~ "#.*" && $s2_m =~ "#.*")) {
	    die "Internal error";
	}
	if(! ($s1_es eq $s2_es)) {
	    die "Internal error";
	}
	$s1_line = <S1>;
	$s2_line = <S2>;
	chop($s1_line);
	chop($s2_line);
	($s1_k,$s1_time) = split(/ /, $s1_line);
	($s2_k,$s2_time) = split(/ /, $s2_line);
	if($s1_es eq "t") {
	    next;
	}
	elsif($s1_es eq "f") {
	    ;
	}
	elsif($s1_es eq "?") {
	    next;
	}
	else {
	    die "Internal error: '$s1_es'";
	}
	if($s1_s eq "'f'" && $s2_s eq "'f'" && $s1_k >= 0 && $s2_k >= 0) {
	    #print TMP "$index $s1_k $s2_k ";
	    #print TMP $index+0.3 . "\n";
	    push(@a, [$s1_k,$s2_k]);
	}
    }
    close(S1);
    close(S2);

    @b = sort by_first @a;
    $index = 1;
    $j = 0;
    $l = @b;
    $m = 0;
    while($j < $l) {
	print TMP "$index ".@b[$j]->[0]." ".@b[$j]->[1]." ";
	print TMP $index+0.3 . "\n";
	if(@b[$j]->[0] > $m) {
	    $m = @b[$j]->[0];
	}
	if(@b[$j]->[1] > $m) {
	    $m = @b[$j]->[1];
	}
	#$m = &max($m, @b[$j]->[1]);
	$j = $j+1;
	$index = $index + 1;
    }

    close(TMP);
    
    open(TMP, ">make_plot.gpl");
    print TMP "set out '$out'\n";
    print TMP "set terminal postscript eps color\n";
    print TMP "unset log\n";
    print TMP "set autoscale\n";
    print TMP "set size square\n";
    #print TMP "set xrange [0.01:60000]\n";
    #print TMP "set yrange [0.01:60000]\n";
    print TMP "set xlabel \"$t1\"\n";
    print TMP "set ylabel \"$t2\"\n";
    print TMP "set title \"time\"\n";
    print TMP "plot \"bound_data.tmp\" using 2:3 title \"\" with points lt -1 pt 12, x title \"\"\n";
    print TMP "quit\n";
    close(TMP);
    system("gnuplot < make_plot.gpl");

    open(TMP, ">make_plot.gpl");
    print TMP "set out '$outbar'\n";
    print TMP "set terminal postscript eps\n";
    print TMP "set boxwidth 0.3 absolute\n";
    print TMP "set style fill pattern 0 border\n";
    #print TMP "set samples 11, 11\n";
    #set noxtics
    print TMP "unset xtics\n";
    print TMP "set title \"counterexample length\"\n";
    print TMP "set autoscale\n";
    #print TMP ("set yrange [ 0 : ",$m+11,"] noreverse nowriteback\n");
    print TMP ("set yrange [ 0 : ",$m*1.1,"]\n");
    print TMP "plot \"bound_data.tmp\" using 1:2 title '$t1' with boxes lt -1, \"bound_data.tmp\" using 4:3 title '$t2' with boxes lt -1\n";
    print TMP "quit\n";
    close(TMP);
    system("gnuplot < make_plot.gpl");
}
