#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include "l2s.h"

/*------------------------------------------------------------------------*/
/* test driver                                                            */
/*------------------------------------------------------------------------*/

#define TEST(name) \
do { \
  extern int L2s_test_ ## name(FILE *log); \
  L2s_TestSuite_registerTestCase( \
      ts, # name, L2s_test_ ## name); \
} while(0)

/*------------------------------------------------------------------------*/

static void
L2s_runtests ()
{
  L2s_TestSuite *ts;

  ts = L2s_TestSuite_new ();
  TEST (PLTLBFormula_print_p);
  TEST (PLTLBFormula_print_NOTp);
  TEST (PLTLBFormula_print_pORq);
  TEST (PLTLBFormula_print_pANDq);
  TEST (PLTLBFormula_print_pIMPLICATIONq);
  TEST (PLTLBFormula_print_pEQUIVALENCEq);
  TEST (PLTLBFormula_print_Xp);
  TEST (PLTLBFormula_print_pUq);
  TEST (PLTLBFormula_print_pVq);
  TEST (PLTLBFormula_print_Fp);
  TEST (PLTLBFormula_print_Gp);
  TEST (PLTLBFormula_print_Yp);
  TEST (PLTLBFormula_print_Zp);
  TEST (PLTLBFormula_print_pSq);
  TEST (PLTLBFormula_print_pTq);
  TEST (PLTLBFormula_print_Op);
  TEST (PLTLBFormula_print_Hp);
  TEST (BMCNdetEncoder_p);
  TEST (BMCNdetEncoder_NOTp);
  TEST (BMCNdetEncoder_pORq);
  TEST (BMCNdetEncoder_pANDq);
  TEST (BMCNdetEncoder_pIMPLICATIONq);
  TEST (BMCNdetEncoder_pEQUIVALENCEq);
  TEST (BMCNdetEncoder_Xp);
  TEST (BMCNdetEncoder_pUq);
  TEST (BMCNdetEncoder_pVq);
  TEST (BMCNdetEncoder_Fp);
  TEST (BMCNdetEncoder_Gp);
  TEST (BMCNdetEncoder_Yp);
  TEST (BMCNdetEncoder_Zp);
  TEST (BMCNdetEncoder_pSq);
  TEST (BMCNdetEncoder_pTq);
  TEST (BMCNdetEncoder_Op);
  TEST (BMCNdetEncoder_Hp);
  TEST (CGHTightEncoder_p);
  TEST (CGHTightEncoder_NOTp);
  TEST (CGHTightEncoder_pORq);
  TEST (CGHTightEncoder_pANDq);
  TEST (CGHTightEncoder_pIMPLICATIONq);
  TEST (CGHTightEncoder_pEQUIVALENCEq);
  TEST (CGHTightEncoder_Xp);
  TEST (CGHTightEncoder_pUq);
  TEST (CGHTightEncoder_pVq);
  TEST (CGHTightEncoder_Fp);
  TEST (CGHTightEncoder_Gp);
  TEST (CGHTightEncoder_Yp);
  TEST (CGHTightEncoder_Zp);
  TEST (CGHTightEncoder_pSq);
  TEST (CGHTightEncoder_pTq);
  TEST (CGHTightEncoder_Op);
  TEST (CGHTightEncoder_Hp);
  TEST (SimpleParser_parse_p);
  TEST (SimpleParser_parse_NOTp);
  TEST (SimpleParser_parse_pORq);
  TEST (SimpleParser_parse_pANDq);
  TEST (SimpleParser_parse_pIMPLICATIONq);
  TEST (SimpleParser_parse_pEQUIVALENCEq);
  TEST (SimpleParser_parse_Xp);
  TEST (SimpleParser_parse_pUq);
  TEST (SimpleParser_parse_pVq);
  TEST (SimpleParser_parse_Fp);
  TEST (SimpleParser_parse_Gp);
  TEST (SimpleParser_parse_Yp);
  TEST (SimpleParser_parse_Zp);
  TEST (SimpleParser_parse_pSq);
  TEST (SimpleParser_parse_pTq);
  TEST (SimpleParser_parse_Op);
  TEST (SimpleParser_parse_Hp);
  L2s_TestSuite_execute (ts);
  L2s_TestSuite_delete (ts);
}

/*------------------------------------------------------------------------*/

int
main (int argc, char *argv[])
{
  L2s_runtests();
  return 0;
}

/*------------------------------------------------------------------------*/
