#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "l2s.h"

/*------------------------------------------------------------------------*/
/* test framework                                                         */
/*------------------------------------------------------------------------*/

struct L2s_TestCase
{
  char *name;
  TestFun f;
};

/*------------------------------------------------------------------------*/

L2s_TestCase * L2s_TestCase_new (char *name, TestFun f)
{
  L2s_TestCase *tc;

  assert (name);
  assert (f);
  tc = (L2s_TestCase *) malloc (sizeof (L2s_TestCase));
  assert (tc);
  tc->name = name;
  tc->f = f;
  return tc;
}

/*------------------------------------------------------------------------*/

int
L2s_TestCase_execute (L2s_TestCase * tc)
{
  char *logname, *outname;
  FILE *log;
  int res;

  assert (tc);
  logname = (char *) malloc (strlen (tc->name) + 10);
  outname = (char *) malloc (strlen (tc->name) + 10);
  sprintf (logname, "log/%s.log", tc->name);
  sprintf (outname, "log/%s.out", tc->name);
  log = fopen (logname, "w");
  res = 1;
  res = res && tc->f (log);
  fclose (log);
  res = res && cmp_files (logname, outname);
  free(logname);
  free(outname);
  return res;
}

/*------------------------------------------------------------------------*/

void
L2s_TestCase_delete (L2s_TestCase * tc)
{
  assert (tc);
  free (tc);
}

/*------------------------------------------------------------------------*/

struct L2s_TestSuite
{
  L2s_TestCase **testcases;
  int num;			/* current number of testcases */
  int capacity;			/* capacity of testcases */
  int executed;
  int passed;
  int failed;
};

/*------------------------------------------------------------------------*/

L2s_TestSuite *
L2s_TestSuite_new ()
{
  L2s_TestSuite *ts;

  ts = (L2s_TestSuite *) malloc (sizeof (L2s_TestSuite));
  assert (ts);
  ts->testcases = (L2s_TestCase **) malloc (sizeof (L2s_TestCase *) * 10);
  assert (ts->testcases);
  ts->num = 0;
  ts->capacity = 10;
  ts->executed = 0;
  ts->passed = 0;
  ts->failed = 0;
  return ts;
}

/*------------------------------------------------------------------------*/

void
L2s_TestSuite_addTestCase (L2s_TestSuite * ts, L2s_TestCase * tc)
{
  assert (ts);
  assert (tc);
  assert (ts->num <= ts->capacity);
  if (ts->num == ts->capacity)
    {
      ts->capacity *= 2;
      ts->testcases =
	(L2s_TestCase **) realloc (ts->testcases,
				   sizeof (L2s_TestCase *) * ts->capacity);
      assert (ts->testcases);
    }
  ts->testcases[ts->num++] = tc;
}

/*------------------------------------------------------------------------*/

void
L2s_TestSuite_registerTestCase (L2s_TestSuite * ts, char *name, TestFun f)
{
  L2s_TestCase *tc;

  assert (ts);
  assert (name);
  assert (f);
  tc = L2s_TestCase_new (name, f);
  L2s_TestSuite_addTestCase (ts, tc);
}

/*------------------------------------------------------------------------*/

void
L2s_TestSuite_execute (L2s_TestSuite * ts)
{
  int i, res;
  L2s_TestCase *tc;

  assert (ts);
  assert (ts->num <= ts->capacity);
  ts->executed = ts->passed = ts->failed = 0;
  for (i = 0; i < ts->num; i++)
    {
      tc = ts->testcases[i];
      assert (tc);
      printf ("%s.. ", tc->name);
      ts->executed++;
      res = L2s_TestCase_execute (tc);
      printf ("%s\n", res ? "ok" : "failed");
      if (res)
	ts->passed++;
      else
	ts->failed++;
    }
  printf ("executed: %d, passed %d, failed %d\n", ts->executed, ts->passed,
	  ts->failed);
}

/*------------------------------------------------------------------------*/

void
L2s_TestSuite_delete (L2s_TestSuite * ts)
{
  int i;

  assert (ts);
  assert (ts->num <= ts->capacity);
  for (i = 0; i < ts->num; i++)
    L2s_TestCase_delete (ts->testcases[i]);
  free (ts->testcases);
  free (ts);
}

/*------------------------------------------------------------------------*/
