#include <assert.h>
#include "l2s.h"

/*------------------------------------------------------------------------*/
/* operators of PLTLB                                                     */
/*------------------------------------------------------------------------*/

int
L2s_PLTLBOperator_isNullary (L2s_PLTLBOperator op)
{
  return ((op == ATOM) || (op == TRUE) || (op == FALSE));
}

/*------------------------------------------------------------------------*/

int
L2s_PLTLBOperator_isUnary (L2s_PLTLBOperator op)
{
  return ((op == NOT) || (op == X) || (op == F) || (op == G) ||
          (op == Y) || (op == Z) || (op == O) || (op == H));
}

/*------------------------------------------------------------------------*/

int
L2s_PLTLBOperator_isBinary (L2s_PLTLBOperator op)
{
  return ((op == OR) || (op == AND) || (op == IMPLICATION)
	  || (op == EQUIVALENCE) || (op == U) || (op == V) || (op == S)
	  || (op == T));
}

/*------------------------------------------------------------------------*/

int
L2s_PLTLBOperator_isPast (L2s_PLTLBOperator op)
{
  return ((op == Y) || (op == Z) || (op == S) || (op == T) ||
          (op == O) || (op == H));
}

/*------------------------------------------------------------------------*/

L2s_String *
L2s_PLTLBOperator_toString (L2s_PLTLBOperator op)
{
  L2s_String *str;

  str = L2s_String_new();
  switch (op) {
  case ATOM:
    L2s_String_append(str, "ATOM");
    break;
  case TRUE:
    L2s_String_append(str, "TRUE");
    break;
  case FALSE:
    L2s_String_append(str, "FALSE");
    break;
  case NOT:
    L2s_String_append(str, "!");
    break;
  case OR:
    L2s_String_append(str, "|");
    break;
  case AND:
    L2s_String_append(str, "&");
    break;
  case IMPLICATION:
    L2s_String_append(str, "->");
    break;
  case EQUIVALENCE:
    L2s_String_append(str, "<->");
    break;
  case X:
    L2s_String_append(str, "X");
    break;
  case U:
    L2s_String_append(str, "U");
    break;
  case V:
    L2s_String_append(str, "V");
    break;
  case F:
    L2s_String_append(str, "F");
    break;
  case G:
    L2s_String_append(str, "G");
    break;
  case Y:
    L2s_String_append(str, "Y");
    break;
  case Z:
    L2s_String_append(str, "Z");
    break;
  case S:
    L2s_String_append(str, "S");
    break;
  case T:
    L2s_String_append(str, "T");
    break;
  case O:
    L2s_String_append(str, "O");
    break;
  case H:
    L2s_String_append(str, "H");
    break;
  default:
    assert(0);
    break;
  }
  return str;
}

/*------------------------------------------------------------------------*/
