#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "l2s.h"

/*------------------------------------------------------------------------*/
/* a string                                                               */
/*------------------------------------------------------------------------*/

struct L2s_String
{
  char *s;
  int capacity;
  int len;
};

/*------------------------------------------------------------------------*/

static void
L2s_String_ensurecap (L2s_String * str, int mincapacity)
{
  assert (str);
  assert (mincapacity > 0);
  while (str->capacity < mincapacity)
    {
      str->s = (char *) realloc (str->s, 2 * str->capacity * sizeof (char));
      str->capacity = 2 * str->capacity;
    }
}  

/*------------------------------------------------------------------------*/

L2s_String *
L2s_String_new ()
{
  L2s_String *str;

  str = (L2s_String *) malloc (sizeof (L2s_String));
  assert (str);
  str->s = (char *) malloc (10 * sizeof (char));
  assert (str->s);
  str->capacity = 10;
  str->len = 0;
  return str;
}

/*------------------------------------------------------------------------*/

int
L2s_String_len (L2s_String * str)
{
  assert (str);
  return str->len;
}

/*------------------------------------------------------------------------*/

char
L2s_String_charAt (L2s_String * str, int i)
{
  assert(str);
  assert(i < str->len);
  return str->s[i];
}

/*------------------------------------------------------------------------*/

char *
L2s_String_toCharPtr (L2s_String * str)
{
  char *s;

  assert (str);
  s = (char *) malloc (sizeof (char) * (str->len + 1));
  assert (s);
  memcpy(s, str->s, str->len * sizeof (char));
  s[str->len] = '\0';
  return s;
}

/*------------------------------------------------------------------------*/

void
L2s_String_print (L2s_String * str) {
  char *s;

  assert(str);
  s = L2s_String_toCharPtr(str);
  printf(s);
  free(s);
}

/*------------------------------------------------------------------------*/

void
L2s_String_fprint (L2s_String * str, FILE *dst) {
  char *s;

  assert(str);
  assert(dst);
  s = L2s_String_toCharPtr(str);
  fprintf(dst, s);
  free(s);
}

/*------------------------------------------------------------------------*/
/* returns substring of str starting from position start ending with
   and including position end */

L2s_String *
L2s_String_substring (L2s_String * str, int start, int end)
{
  L2s_String *res;

  assert (str);
  assert (start >= 0 && start < str->len);
  assert (end >= 0 && end < str->len);
  assert (start <= end);
  res = L2s_String_new();
  L2s_String_ensurecap(res, end - start + 1);
  memcpy(res->s, (char *) &str->s[start], (end - start + 1) * sizeof(char));
  res->len = end - start + 1;
  return res;
}

/*------------------------------------------------------------------------*/

void
L2s_String_append (L2s_String * str, char *s)
{
  assert (str);
  assert (s);
  L2s_String_ensurecap(str, str->len + strlen (s));
  memcpy((char *) &str->s[str->len], s, strlen(s) * sizeof(char));
  str->len = str->len + strlen (s);
}

/*------------------------------------------------------------------------*/

void
L2s_String_appendC (L2s_String * str, char c)
{
  assert (str);
  L2s_String_ensurecap(str, str->len + 1);
  str->s[str->len] = c;
  str->len = str->len + 1;
}

/*------------------------------------------------------------------------*/

void
L2s_String_appendS (L2s_String * str, L2s_String * str2)
{
  int len2;

  assert (str);
  assert (str2);
  len2 = L2s_String_len(str2);
  L2s_String_ensurecap(str, str->len + len2);
  memcpy((char *) &str->s[str->len], str2->s, len2 * sizeof(char));
  str->len = str->len + len2;
}

/*------------------------------------------------------------------------*/

L2s_String *
L2s_String_clone (L2s_String * str)
{
  L2s_String *res;

  assert (str);
  res = L2s_String_new();
  assert (res);
  L2s_String_appendS(res, str);
  return res;
}

/*------------------------------------------------------------------------*/

void
L2s_String_delete (L2s_String * str)
{
  assert (str);
  free (str->s);
  free (str);
}

/*------------------------------------------------------------------------*/
