#ifndef L2S_H_INCLUDED
#define L2S_H_INCLUDED
/*------------------------------------------------------------------------*/

#include <stdio.h>

/*------------------------------------------------------------------------*/
/* miscellaneous functions                                                */
/*------------------------------------------------------------------------*/

int min (int i, int j);

int max (int i, int j);

int cmp_files (char *name0, char *name1);

/*------------------------------------------------------------------------*/
/* a string                                                               */
/*------------------------------------------------------------------------*/

typedef struct L2s_String L2s_String;

L2s_String * L2s_String_new ();

int L2s_String_len (L2s_String * str);

void L2s_String_append (L2s_String * str, char *s);

void L2s_String_appendC (L2s_String * str, char c);

void L2s_String_appendS (L2s_String * str, L2s_String * str2);

char L2s_String_charAt (L2s_String * str, int i);

L2s_String * L2s_String_substring (L2s_String * str, int start, int end);

char * L2s_String_toCharPtr (L2s_String * str);

void L2s_String_print (L2s_String * str);

void L2s_String_fprint (L2s_String * str, FILE *dst);

L2s_String * L2s_String_clone (L2s_String * str);

void L2s_String_delete (L2s_String * str);

/*------------------------------------------------------------------------*/
/* operators of PLTLB                                                     */
/*------------------------------------------------------------------------*/

typedef enum L2s_PLTLBOperator L2s_PLTLBOperator;

enum L2s_PLTLBOperator
{ ATOM, TRUE, FALSE, NOT, OR, AND, IMPLICATION, EQUIVALENCE, X, U, V, F, G,
  Y, Z, S, T, O, H };

int L2s_PLTLBOperator_isNullary (L2s_PLTLBOperator op);

int L2s_PLTLBOperator_isUnary (L2s_PLTLBOperator op);

int L2s_PLTLBOperator_isBinary (L2s_PLTLBOperator op);

int L2s_PLTLBOperator_isPast (L2s_PLTLBOperator op);

L2s_String * L2s_PLTLBOperator_toString (L2s_PLTLBOperator op);

/*------------------------------------------------------------------------*/
/* PLTLB formula node                                                     */
/*------------------------------------------------------------------------*/

typedef struct L2s_PLTLBNode L2s_PLTLBNode;

L2s_PLTLBNode * L2s_PLTLBNode_new ();

void L2s_PLTLBNode_setOp (L2s_PLTLBNode * node, L2s_PLTLBOperator op);

L2s_PLTLBOperator L2s_PLTLBNode_getOp (L2s_PLTLBNode * node);

void L2s_PLTLBNode_setLeft (L2s_PLTLBNode * node, L2s_PLTLBNode * left);

L2s_PLTLBNode * L2s_PLTLBNode_getLeft (L2s_PLTLBNode * node);

void L2s_PLTLBNode_setRight (L2s_PLTLBNode * node, L2s_PLTLBNode * right);

L2s_PLTLBNode * L2s_PLTLBNode_getRight (L2s_PLTLBNode * node);

void L2s_PLTLBNode_setAtom (L2s_PLTLBNode * node, L2s_String * atom);

L2s_String * L2s_PLTLBNode_getAtom (L2s_PLTLBNode * node);

int L2s_PLTLBNode_pod (L2s_PLTLBNode * node);

L2s_String * L2s_PLTLBNode_toString (L2s_PLTLBNode * phi);

void L2s_PLTLBNode_delete (L2s_PLTLBNode * node);

/*------------------------------------------------------------------------*/
/* PLTLB formula                                                          */
/*------------------------------------------------------------------------*/

typedef struct L2s_PLTLBFormula L2s_PLTLBFormula;

L2s_PLTLBFormula * L2s_PLTLBFormula_new ();

void L2s_PLTLBFormula_setTop (L2s_PLTLBFormula *f, L2s_PLTLBNode *top);

L2s_PLTLBNode * L2s_PLTLBFormula_getTop (L2s_PLTLBFormula *f);

L2s_String * L2s_PLTLBFormula_toString (L2s_PLTLBFormula * f);

void L2s_PLTLBFormula_delete (L2s_PLTLBFormula * f);

/*------------------------------------------------------------------------*/
/* encoder for PLTLB formula                                              */
/*------------------------------------------------------------------------*/

typedef enum L2s_Encoding L2s_Encoding;

enum L2s_Encoding { BMCNdet, CGHTight };

typedef struct L2s_Encoder L2s_Encoder;

L2s_Encoder * L2s_Encoder_new ();

void L2s_Encoder_setEncoding (L2s_Encoder * enc, L2s_Encoding encoding);

void L2s_Encoder_setModulename (L2s_Encoder * enc, L2s_String * modulename);

L2s_String * L2s_Encoder_getModulename (L2s_Encoder * enc);

void L2s_Encoder_setVarprefix (L2s_Encoder * enc, L2s_String * varprefix);

L2s_String * L2s_Encoder_getVarprefix (L2s_Encoder * enc);

void L2s_Encoder_setPropertyvarname (L2s_Encoder * enc, L2s_String * propertyvarname);

L2s_String * L2s_Encoder_getPropertyvarname (L2s_Encoder * enc);

void L2s_Encoder_setPhi (L2s_Encoder * enc, L2s_PLTLBFormula * phi);

void L2s_Encoder_setMaxunroll (L2s_Encoder * enc, int maxunroll);

int L2s_Encoder_getMaxunroll (L2s_Encoder * enc);

void L2s_Encoder_encode (L2s_Encoder * enc);

L2s_String * L2s_Encoder_getRes (L2s_Encoder * enc);

void L2s_Encoder_delete (L2s_Encoder * enc);

/*------------------------------------------------------------------------*/
/* nondeterministic encoding described in TACAS'05 sub                    */
/*------------------------------------------------------------------------*/

void L2s_BMCNdetEncoder_enc (L2s_Encoder * enc);

/*------------------------------------------------------------------------*/
/* tight Hamaguchi-like encoding                                          */
/*------------------------------------------------------------------------*/

void L2s_CGHTightEncoder_enc (L2s_Encoder * enc);

/*------------------------------------------------------------------------*/
/* very simple parser for LTL formulae

   format
   - no brackets around formula,
   - brackets around each subformula,
   - atoms extend to the next closing bracket                             */
/*------------------------------------------------------------------------*/

typedef struct L2s_SimpleParser L2s_SimpleParser;

L2s_SimpleParser * L2s_SimpleParser_new();

void L2s_SimpleParser_setLog(L2s_SimpleParser *pars, FILE *log);

void L2s_SimpleParser_setInput(L2s_SimpleParser *pars, L2s_String *input);

void L2s_SimpleParser_parse(L2s_SimpleParser *pars);

L2s_PLTLBFormula * L2s_SimpleParser_getPhi(L2s_SimpleParser *pars);

void L2s_SimpleParser_delete(L2s_SimpleParser *pars);

/*------------------------------------------------------------------------*/
/* test framework                                                         */
/*------------------------------------------------------------------------*/

typedef int (*TestFun) (FILE * log);

typedef struct L2s_TestCase L2s_TestCase;

L2s_TestCase * L2s_TestCase_new (char *name, TestFun f);

int L2s_TestCase_execute (L2s_TestCase * tc);

void L2s_TestCase_delete (L2s_TestCase * tc);

/*------------------------------------------------------------------------*/

typedef struct L2s_TestSuite L2s_TestSuite;

L2s_TestSuite * L2s_TestSuite_new ();

void L2s_TestSuite_addTestCase (L2s_TestSuite * ts, L2s_TestCase * tc);

void L2s_TestSuite_registerTestCase (L2s_TestSuite * ts, char *name, TestFun f);

void L2s_TestSuite_execute (L2s_TestSuite * ts);

void L2s_TestSuite_delete (L2s_TestSuite * ts);

/*------------------------------------------------------------------------*/
#endif
