#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <limits.h>
#include "l2s.h"
#include "encoder.h"

/*------------------------------------------------------------------------*/
/* encoder for PLTLB formula                                              */
/*------------------------------------------------------------------------*/

#define L2S_ENCODER_VARPREFIX_DEFAULT "z_"
#define L2S_ENCODER_PROPERTYVARNAME_DEFAULT "z_0_0"

/*------------------------------------------------------------------------*/

L2s_Encoder *
L2s_Encoder_new ()
{
  L2s_Encoder *enc;

  enc = (L2s_Encoder *) malloc (sizeof (L2s_Encoder));
  assert (enc);
  enc->encoding = BMCNdet;
  enc->modulename = NULL;
  enc->varprefix = L2s_String_new ();
  L2s_String_append(enc->varprefix, L2S_ENCODER_VARPREFIX_DEFAULT);
  enc->propertyvarname = L2s_String_new();
  L2s_String_append(enc->propertyvarname, L2S_ENCODER_PROPERTYVARNAME_DEFAULT);
  enc->phi = NULL;
  enc->maxunroll = INT_MAX;
  enc->res = L2s_String_new();
  enc->id = 0;
  return enc;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_setEncoding (L2s_Encoder * enc, L2s_Encoding encoding)
{
  assert (enc);
  enc->encoding = encoding;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_setModulename (L2s_Encoder * enc, L2s_String * modulename)
{
  assert (enc);
  assert (modulename);
  if (enc->modulename)
    L2s_String_delete(enc->modulename);
  enc->modulename = L2s_String_clone(modulename);
}

/*------------------------------------------------------------------------*/

L2s_String *
L2s_Encoder_getModulename (L2s_Encoder * enc)
{
  assert (enc);
  return enc->modulename;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_setVarprefix (L2s_Encoder * enc, L2s_String * varprefix)
{
  assert (enc);
  assert (varprefix);
  if (enc->varprefix)
    L2s_String_delete(enc->varprefix);
  enc->varprefix = L2s_String_clone(varprefix);
}

/*------------------------------------------------------------------------*/

L2s_String *
L2s_Encoder_getVarprefix (L2s_Encoder * enc)
{
  assert (enc);
  return enc->varprefix;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_setPropertyvarname (L2s_Encoder * enc, L2s_String * propertyvarname)
{
  assert (enc);
  assert (propertyvarname);
  if (enc->propertyvarname)
    L2s_String_delete(enc->propertyvarname);
  enc->propertyvarname = L2s_String_clone(propertyvarname);
}

/*------------------------------------------------------------------------*/

L2s_String *
L2s_Encoder_getPropertyvarname (L2s_Encoder * enc)
{
  assert (enc);
  return enc->propertyvarname;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_setPhi (L2s_Encoder * enc, L2s_PLTLBFormula * phi)
{
  assert (enc);
  assert (phi);
  enc->phi = phi;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_setMaxunroll (L2s_Encoder * enc, int maxunroll)
{
  assert (enc);
  assert (maxunroll >= 0);
  enc->maxunroll = maxunroll;
}

/*------------------------------------------------------------------------*/

int
L2s_Encoder_getMaxunroll (L2s_Encoder * enc)
{
  assert (enc);
  return enc->maxunroll;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_encode (L2s_Encoder * enc)
{
  assert (enc);
  if (enc->encoding == BMCNdet)
    L2s_BMCNdetEncoder_enc (enc);
  else if (enc->encoding == CGHTight)
    L2s_CGHTightEncoder_enc (enc);
  else
    assert(0);
}

/*------------------------------------------------------------------------*/

L2s_String *
L2s_Encoder_getRes (L2s_Encoder * enc)
{
  assert (enc);
  return enc->res;
}

/*------------------------------------------------------------------------*/

void
L2s_Encoder_delete (L2s_Encoder * enc)
{
  assert (enc);
  if (enc->modulename)
    L2s_String_delete(enc->modulename);
  if (enc->varprefix)
    L2s_String_delete(enc->varprefix);
  if (enc->propertyvarname)
    L2s_String_delete(enc->propertyvarname);
  free (enc);
}

/*-------------------------------------------------------------------------*/
