/**CHeaderFile*****************************************************************

  FileName    [SatMinisat.h]

  PackageName [SatMinisat]

  Synopsis    [The header file for the SatMinisat class.]

  Description [Minisat is an incremental SAT solver. 
  SatMinisat inherits the SatIncSolver (interface) class]

  SeeAlso     []

  Author      [Andrei Tchaltsev]

  Copyright   [
  This file is part of the ``sat'' package of NuSMV version 2. 
  Copyright (C) 2004 by ITC-irst.

  NuSMV version 2 is free software; you can redistribute it and/or 
  modify it under the terms of the GNU Lesser General Public 
  License as published by the Free Software Foundation; either 
  version 2 of the License, or (at your option) any later version.

  NuSMV version 2 is distributed in the hope that it will be useful, 
  but WITHOUT ANY WARRANTY; without even the implied warranty of 
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public 
  License along with this library; if not, write to the Free Software 
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.

  For more information of NuSMV see <http://nusmv.irst.itc.it>
  or email to <nusmv-users@irst.itc.it>.
  Please report bugs to <nusmv-users@irst.itc.it>.

  To contact the NuSMV development board, email to <nusmv@irst.itc.it>. ]

  Revision    [$Id: SatMinisat.h,v 1.1.2.2 2004/07/28 17:19:58 nusmv Exp $]

******************************************************************************/

#ifndef __SAT_SOLVER_SAT_MINISAT__H
#define __SAT_SOLVER_SAT_MINISAT__H

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include "sat/SatIncSolver.h" 

/*---------------------------------------------------------------------------*/
/* Constant declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/
typedef struct SatMinisat_TAG* SatMinisat_ptr;

/*---------------------------------------------------------------------------*/
/* Variable declarations                                                     */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Macro declarations                                                        */
/*---------------------------------------------------------------------------*/
#define SAT_MINISAT(x) \
	 ((SatMinisat_ptr) x)

#define SAT_MINISAT_CHECK_INSTANCE(x) \
	 (nusmv_assert(SAT_MINISAT(x) != SAT_MINISAT(NULL)))

/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Function prototypes                                                       */
/*---------------------------------------------------------------------------*/

/* SatMinisat Constructor/Destructors */
EXTERN SatMinisat_ptr SatMinisat_create ARGS((const char* name));
EXTERN void SatMinisat_destroy ARGS((SatMinisat_ptr self));

/**AutomaticEnd***************************************************************/

#endif /* __SAT_SOLVER_SAT_MINISAT__H */
