/*2004 Timo Latvala <timo.latvala@hut.fi>. See the file LGPL-2.1 for details.*/
#ifndef bmcNodeStack_h_
#define bmcNodeStack_h_
#include "node.h" /*For node_ptr*/
#include "util.h" /* for ARGS and EXTERN */


/**Type declarations*/
struct nodeStack {
  /**Number of slots allocated*/
  unsigned alloc;
  /**Number of slots occupied*/
  unsigned first_free;
  /**The table*/
  node_ptr *table; 
};

typedef struct nodeStack *Bmc_Stack_ptr;

/**Function prototypes*/

EXTERN Bmc_Stack_ptr Bmc_Stack_new_stack ARGS((void));
EXTERN void Bmc_Stack_push ARGS((Bmc_Stack_ptr, node_ptr));
EXTERN node_ptr Bmc_Stack_pop ARGS((Bmc_Stack_ptr));
EXTERN void Bmc_Stack_delete ARGS((Bmc_Stack_ptr stack));
EXTERN unsigned Bmc_Stack_size ARGS((Bmc_Stack_ptr stack));
EXTERN node_ptr Bmc_Stack_top ARGS((Bmc_Stack_ptr stack));

#endif /*bmcNodeStack_h_*/
