/*2004 Timo Latvala <timo.latvala@hut.fi>. See the file LGPL-2.1 for details.*/
/**A hashtable for (node, unsigned) pairs*/

#include <stdlib.h>
#include "bmcNodeStack.h"
#include "utils/utils.h"

/**Constant declarations*/

#define STACK_SIZE 127


/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*/
/* Definition of exported functions                                          */
/*---------------------------------------------------------------------------*/

/**Create a new stack*/

Bmc_Stack_ptr 
Bmc_Stack_new_stack()
{
  unsigned i;
  Bmc_Stack_ptr thestack = (Bmc_Stack_ptr) malloc(sizeof(struct nodeStack));
  thestack->alloc=STACK_SIZE;
  thestack->first_free=0;
  thestack->table = (node_ptr *) malloc(sizeof(node_ptr) * thestack->alloc);
  if (thestack->table == NULL) {
    fprintf(stderr, "new_stack: Out of Memory\n");
    exit(1);
  }
  for(i=thestack->alloc; i--; ) {
    thestack->table[i]=0;
  }
  return thestack;
}

/**Push a node unto the stack
 */

void Bmc_Stack_push(Bmc_Stack_ptr thestack, node_ptr node) 
{ 
  if(thestack->first_free >= thestack->alloc) { /**The stack needs to grow*/
    unsigned i;
    thestack->alloc=2*thestack->alloc;
    node_ptr *temp=malloc(sizeof(node_ptr)*thestack->alloc); 
    nusmv_assert(temp!=NULL);
    for(i=thestack->first_free; i--; ) {
      temp[i]=thestack->table[i];
    }
    free(thestack->table);
    thestack->table=temp;    
  }
  /**Put node on stack*/
  thestack->table[thestack->first_free]=node;
  thestack->first_free++;
  return;
}

/**@return the number of occupied slots*/
unsigned Bmc_Stack_size(Bmc_Stack_ptr thestack) 
{  
  return thestack->first_free;
}

/**Pop an element from the stack
 * @return the top element of the stack
 */
node_ptr Bmc_Stack_pop (Bmc_Stack_ptr thestack)
{
  nusmv_assert(thestack->first_free>0);
  thestack->first_free--;
  return thestack->table[thestack->first_free];
}

/**delete the stack*/

void Bmc_Stack_delete(Bmc_Stack_ptr thestack)
{
  free(thestack->table);
  free(thestack);
}


/*@return the top element of the stack*/
node_ptr Bmc_Stack_top(Bmc_Stack_ptr thestack)
{
  nusmv_assert(thestack->first_free > 0);
  return thestack->table[thestack->first_free - 1];
}


/*---------------------------------------------------------------------------*/
/* Definition of static functions                                            */
/*---------------------------------------------------------------------------*/
