/*2004 Timo Latvala <timo.latvala@hut.fi>. See the file LGPL-2.1 for details*/

#ifndef bmchash_h_
#define bmchash_h_
#define BMC_HASH_NOTFOUND -1
#include "node.h" /*For node_ptr*/
#include "util.h" /* for ARGS and EXTERN */


struct table_pair {
  node_ptr key;
  int data;
};


/**Type declarations*/
struct htable {
  /**Number of slots allocated*/
  unsigned alloc;
  /**Number of slots occupied*/
  unsigned occupied;
  /**The table*/
  struct table_pair *table; 
};

typedef struct htable *hashPtr;

/**Function prototypes*/

EXTERN hashPtr Bmc_Hash_new_htable ARGS((void));
EXTERN int Bmc_Hash_find ARGS((hashPtr, node_ptr));
EXTERN void Bmc_Hash_insert ARGS((hashPtr, node_ptr, int));
EXTERN void Bmc_Hash_delete_table ARGS((hashPtr hash));
EXTERN unsigned Bmc_Hash_size ARGS((hashPtr hash));

#endif /*bmchash_h_*/
