#include "be/be.h"
#include "rbc/rbcInt.h"
#include "rbc.h"


/*---------------------------------------------------------------------------*/
/* Stucture declarations                                                     */
/*---------------------------------------------------------------------------*/

struct SexprDfsDataTJ
{
  FILE * outFile;
  BmcVarsMgr_ptr varsManager;
};

struct TJGetVarsData
{
  BmcVarsMgr_ptr varsManager;
  hash_ptr       seen_vars;
  lsList         var_list;
};


/*---------------------------------------------------------------------------*/
/* Type declarations                                                         */
/*---------------------------------------------------------------------------*/

typedef struct SexprDfsDataTJ SexprDfsDataTJ_t;

typedef struct TJGetVarsData TJGetVarsData_t;


/*---------------------------------------------------------------------------*/
/* Auxiliary stuff
/*---------------------------------------------------------------------------*/

/* Auxiliary data structure code for a set of node_ptr */
static hash_ptr _set_create();
static void     _set_destroy(hash_ptr hash);
static void     _set_insert(hash_ptr hash, node_ptr bexp);
static int      _set_is_in(hash_ptr hash, node_ptr bexp);

static hash_ptr _set_create()
{
  hash_ptr hash = new_assoc();
  nusmv_assert(hash != (hash_ptr) NULL);
}

static void _set_destroy(hash_ptr hash)
{
  if(hash != (hash_ptr) NULL)
    free_assoc(hash);
}

static void _set_insert(hash_ptr hash, node_ptr bexp)
{
  nusmv_assert(hash != (hash_ptr) NULL);
  nusmv_assert((node_ptr)1 != (node_ptr)NULL);
  insert_assoc(hash, bexp, (node_ptr)1);
}

static int _set_is_in(hash_ptr hash, node_ptr bexp)
{
  node_ptr result;
  nusmv_assert(hash != (hash_ptr) NULL);
  result = find_assoc(hash, bexp);
  if(result == (node_ptr)NULL)
    return 0;
  return 1;
}



/**AutomaticStart*************************************************************/

/*---------------------------------------------------------------------------*/
/* Static function prototypes                                                */
/*---------------------------------------------------------------------------*/

static int SexprTJSet(Rbc_t * f, char * SexprData, int sign);
static void SexprTJFirst(Rbc_t * f, char * SexprData, int sign);
static void SexprTJBack(Rbc_t * f, char * SexprData, int sign);
static void SexprTJLast(Rbc_t * f, char * SexprData, int sign);


static int  TJGetVars_Set(Rbc_t * f, char * SexprData, int sign);
static void TJGetVars_First(Rbc_t * f, char * SexprData, int sign);
static void TJGetVars_Back(Rbc_t * f, char * SexprData, int sign);
static void TJGetVars_Last(Rbc_t * f, char * SexprData, int sign);



/**Function********************************************************************

  Synopsis    [Print out an rbc. ]

  Description [Print out an rbc. ]

  SideEffects [None]

  SeeAlso     []

******************************************************************************/

void
Rbc_OutputSexprTJ(
  BmcVarsMgr_ptr  varsManager,
  Rbc_Manager_t * rbcManager,
  Rbc_t         * f,
  FILE          * outFile)
{
  Dag_DfsFunctions_t SexprFunctions;
  SexprDfsDataTJ_t   SexprDataTJ;

  /* Cleaning the user fields. */
  Dag_Dfs(f, &dag_DfsClean, NIL(char));

  /* Setting up the DFS functions. */
  SexprFunctions.Set        = SexprTJSet;
  SexprFunctions.FirstVisit = SexprTJFirst;
  SexprFunctions.BackVisit  = SexprTJBack;
  SexprFunctions.LastVisit  = SexprTJLast;

 /* Setting up the DFS data. */
  SexprDataTJ.outFile = outFile;
  SexprDataTJ.varsManager = varsManager;

  /* Calling DFS on f. */
  Dag_Dfs(f, &SexprFunctions, (char*)(&SexprDataTJ));

  return;

}


static int
SexprTJSet(
 Rbc_t  * f,
 char   * SexprData,
 int      sign)
{

  /* Always visit (a simple expression is a tree). */
  return (-1);

}

static void
SexprTJFirst(
 Rbc_t  * f,
 char   * SexprData,
 int      sign)
{
  SexprDfsDataTJ_t * sd   = (SexprDfsDataTJ_t*)SexprData;

  /* If the sign is negative print out a negation. */
  if (sign == RBC_FALSE) {
    fprintf(sd -> outFile, "(NOT ");
  }

  /* If this an operator print out its label. */
  switch (f -> symbol) {
  case RBCTOP:
    fprintf(sd -> outFile, "(TRUE ");
    break;
  case RBCAND:
    fprintf(sd -> outFile, "(AND ");
    break;
  case RBCIFF:
    fprintf(sd -> outFile, "(IFF ");
    break;
  case RBCITE:
    fprintf(sd -> outFile, "(ITE ");
    break;
  case RBCVAR:
    {
      int index, time = -1;
      const int nof_state_vars = BmcVarsMgr_GetStateVarsNum(sd->varsManager);
      const int nof_input_vars = BmcVarsMgr_GetInputVarsNum(sd->varsManager);
      const int size_of_untimed_block = nof_state_vars * 2 + nof_input_vars;

      if((int)(f->data) >= size_of_untimed_block)
        {
          index = ((int)(f->data) - size_of_untimed_block) %
            (nof_state_vars + nof_input_vars);
          time = ((int)(f->data) - size_of_untimed_block) /
            (nof_state_vars + nof_input_vars);
          print_node(sd->outFile,
                     BmcVarsMgr_VarIndex2Name(sd->varsManager,index));
          fprintf(sd->outFile, "@%d", time);
        }
      else
        {
          if((int)(f->data) >= nof_state_vars + nof_input_vars) {
            index = (int)(f->data) - (nof_state_vars + nof_input_vars);
            print_node(sd->outFile,
                       BmcVarsMgr_VarIndex2Name(sd->varsManager,index));
            fprintf(sd->outFile, "'");
          } else {
            print_node(sd->outFile,
                       BmcVarsMgr_VarIndex2Name(sd->varsManager,
                                                (int)(f->data)));
          }
        }

      /*
      be_ptr be =  Be_Manager_Spec2Be(BmcVarsMgr_GetBeMgr(sd->varsManager), f);
      print_node(sd->outFile, BmcVarsMgr_Timed2Name(sd->varsManager, be));
      */
      /*
      fprintf(sd -> outFile, "X%d", (int)(f -> data));
      */
      break;
    }
  default:
    break;
  }

  /* Set the user-defined integer data to 1 to remember operands. */
  f -> iRef = 1;

  return;

} /* End of SexprFirst. */


static void
SexprTJBack(
 Rbc_t  * f,
 char   * SexprData,
 int      sign)
{
  SexprDfsDataTJ_t * sd   = (SexprDfsDataTJ_t*)SexprData;

  if (f -> iRef == 1) {
    fprintf(sd -> outFile, " ");
    --(f -> iRef);
  }

  return;

}


static void
SexprTJLast(
 Rbc_t  * f,
 char   * SexprData,
 int      sign)
{
  SexprDfsDataTJ_t * sd   = (SexprDfsDataTJ_t*)SexprData;


  /* Close the operator. */
  if (f -> symbol != RBCVAR) {
    fprintf(sd -> outFile, ")");
  }

  /* Close the negation. */
  if (sign == RBC_FALSE) {
    fprintf(sd -> outFile, ")");
  }

  return;

}


/**Function********************************************************************

  Synopsis    [Get the list of vars appearing in an rbc. ]

  Description [Get the list of vars appearing in an rbc. ]

  SideEffects [None]

  SeeAlso     []

******************************************************************************/

lsList
Rbc_TJ_get_vars(
  BmcVarsMgr_ptr  varsManager,
  Rbc_Manager_t * rbcManager,
  Rbc_t         * f)
{
  Dag_DfsFunctions_t Functions;
  TJGetVarsData_t    Data;

  /* Cleaning the user fields. */
  Dag_Dfs(f, &dag_DfsClean, NIL(char));

  /* Setting up the DFS functions. */
  Functions.Set        = TJGetVars_Set;
  Functions.FirstVisit = TJGetVars_First;
  Functions.BackVisit  = TJGetVars_Back;
  Functions.LastVisit  = TJGetVars_Last;

  /* Setting up the DFS data. */
  Data.varsManager = varsManager;
  Data.seen_vars = _set_create();
  Data.var_list = lsCreate();

  /* Calling DFS on f. */
  Dag_Dfs(f, &Functions, (char*)(&Data));

  _set_destroy(Data.seen_vars);

  return Data.var_list;
}


static int
TJGetVars_Set(
 Rbc_t  * f,
 char   * Data,
 int      sign)
{
  return (0);
}

static void
TJGetVars_First(
 Rbc_t  * f,
 char   * Data,
 int      sign)
{
  TJGetVarsData_t *sd   = (TJGetVarsData_t*)Data;

  /* If this an operator print out its label. */
  if(f->symbol == RBCVAR)
    {
      int index, time = -1;
      const int nof_state_vars = BmcVarsMgr_GetStateVarsNum(sd->varsManager);
      const int nof_input_vars = BmcVarsMgr_GetInputVarsNum(sd->varsManager);
      const int size_of_untimed_block = nof_state_vars * 2 + nof_input_vars;
      node_ptr node = 0;

      if((int)(f->data) >= size_of_untimed_block)
        {
          index = ((int)(f->data) - size_of_untimed_block) %
            (nof_state_vars + nof_input_vars);
          node = BmcVarsMgr_VarIndex2Name(sd->varsManager, index);
        }
      else
        {
          if((int)(f->data) >= nof_state_vars + nof_input_vars)
	    {
	      index = (int)(f->data) - (nof_state_vars + nof_input_vars);
	      node = BmcVarsMgr_VarIndex2Name(sd->varsManager,index);
	    }
	  else
	    {
	      node = BmcVarsMgr_VarIndex2Name(sd->varsManager, (int)(f->data));
	    }
        }

      if(!_set_is_in(sd->seen_vars, node))
	{
	  _set_insert(sd->seen_vars, node);
	  lsNewEnd(sd->var_list, (lsGeneric)node, LS_NH);
	}
    }

  return;

} /* End of First. */


static void
TJGetVars_Back(
 Rbc_t  * f,
 char   * Data,
 int      sign)
{
  TJGetVarsData_t * sd   = (TJGetVarsData_t*)Data;

  return;
}


static void
TJGetVars_Last(
 Rbc_t  * f,
 char   * Data,
 int      sign)
{
  TJGetVarsData_t * sd   = (TJGetVarsData_t*)Data;
  return;
}


