#ifndef BMC_INCRSAT_H
#define BMC_INCRSAT_H

#include "rbc/rbc.h"

/* a flag returned by the 'solve' methods */
typedef enum Bmc_IncrSat_result_TAG
{ BMC_INCRSAT_INTERNAL_ERROR=-1,
  BMC_INCRSAT_TIMEOUT,
  BMC_INCRSAT_MEMOUT,
  BMC_INCRSAT_SATISFIABLE_PROBLEM,
  BMC_INCRSAT_UNSATISFIABLE_PROBLEM,
  BMC_INCRSAT_UNAVAILABLE
} Bmc_IncrSat_result;


typedef struct Bmc_IncrSat_TAG * Bmc_IncrSat_ptr;

extern Bmc_IncrSat_ptr Bmc_IncrSat_init(const char *solver_name);
extern void Bmc_IncrSat_release(Bmc_IncrSat_ptr);

extern void Bmc_IncrSat_new_frame(Bmc_IncrSat_ptr);
extern void Bmc_IncrSat_pop_frame(Bmc_IncrSat_ptr);
extern void Bmc_IncrSat_insert(Bmc_IncrSat_ptr, Rbc_t *);
extern void Bmc_IncrSat_force_false(Bmc_IncrSat_ptr, Rbc_t *);
extern void Bmc_IncrSat_force_true(Bmc_IncrSat_ptr, Rbc_t *);
extern Bmc_IncrSat_result Bmc_IncrSat_solve(Bmc_IncrSat_ptr);
extern int Bmc_IncrSat_get_solution_value(Bmc_IncrSat_ptr, Rbc_t *);

#endif
